% Example 12.7 movie

% Photoacoustic signal from a homogeneously heated slab
% Use SI units

fig=figure(1);
set(fig,'DoubleBuffer','on'); % Flash-free rendering for animations

clear all
vs = 1500;
p0 = 1;
L = 1E-3;
Lhalf = L/2;
zmax = 2;
z = linspace(-zmax, zmax, 1000)*L;

mov = avifile('Example07_PA_Slab.avi')

for t = [0:0.1:2]*Lhalf/vs
 ppos = p0/2.*heaviside(z-(-Lhalf+vs*t)).*heaviside(Lhalf+vs*t-z);
 pneg = p0/2.*heaviside(z-(-Lhalf-vs*t)).*heaviside(Lhalf-vs*t-z);
 p = ppos + pneg;

 subplot(1, 2, 1)
 hold off;
 plot(z/L, ppos/p0, 'k-', z/L, pneg/p0, 'k--')
 grid
 axis([-zmax, zmax, 0, 1.1])
 xlabel('\itz/L')
 ylabel('Partial pressures/\itp\rm_0')
 legend('\itp\rm_+', '\itp\rm_-') 
 
 subplot(1, 2, 2)
 hold off;
 plot(z/L, p/p0, 'k-')
 grid
 axis([-zmax, zmax, 0, 1.1])
 xlabel('z/L')
 ylabel('Total pressure/\itp\rm_0')
 pause(0.01)
 
 mov = addframe(mov,getframe(gcf));
end

mov = close(mov);
