% Example 12.7

% Photoacoustic signal from a homogeneously heated slab
% Use SI units

clear all
vs = 1500;
p0 = 1;
L = 1E-3;
Lhalf = L/2;
zmax = 2;
z = linspace(-zmax, zmax, 1000)*L;

figure(1)
clf

i_axis = 1;
for t = [0:1/2:1, 2]*Lhalf/vs
 ppos = p0/2.*heaviside(z-(-Lhalf+vs*t)).*heaviside(Lhalf+vs*t-z);
 pneg = p0/2.*heaviside(z-(-Lhalf-vs*t)).*heaviside(Lhalf-vs*t-z);
 p = ppos + pneg;

 subplot(4, 2, i_axis, 'align')
 plot(z/L, ppos/p0, 'k-', z/L, pneg/p0, 'k--')
 tick = [.015 .025];
 set(0,'DefaultAxesTickLength',tick)
 title(['\itt\rm = ', num2str(vs*t/L), '\itxL\rm/\itv_s'])
 axis([-zmax, zmax, 0, 1.1])
 if (i_axis == 7)
 xlabel('\itz\rm/\itL')
 end
 ylabel('Partial pressures/\it{p}\rm_0')
 if (i_axis == 1)
 legend('\itp\rm_+', '\itp\rm_-')
 end
 i_axis = i_axis + 1;

 subplot(4, 2, i_axis, 'align')
 plot(z/L, p/p0, 'k-')
 tick = [.015 .025];
 set(0,'DefaultAxesTickLength',tick)
 title(['\itt\rm = ', num2str(vs*t/L), '\itxL\rm/\itv_s'])
 axis([-zmax, zmax, 0, 1.1])
 if (i_axis == 8)
 xlabel('\itz\rm/\itL')
 end
 ylabel('Total pressure/\it{p}\rm_0')
 i_axis = i_axis + 1;
end
