% Example 11.1

c = 3e8/1.37;	%[m/s]
mua = 0.1E2;	%[/m]
mus = 10E2;	%[/m] mus = mus', g = 0
f = 200E6;	%[Hz]

D = 1/(3*(mua+mus));	%[m]
k = sqrt((-c*mua + i*2*pi*f)/(c*D));	%wave vector

disp(['Absorption coeff. mua [/cm] = ', num2str(mua*1E-2)])
disp(['Reduced scattering coeff. mus'' [/cm] = ', num2str(mus*1E-2)])
disp(['Frequency f [MHz] = ', num2str(f*1E-6)])
disp(['Wavelength [cm] = ', num2str(2*pi/real(k)*1E2)])
disp(['Decay const [cm] = ', num2str(1/imag(k)*1E2)])

xs = 1E-2;	%[m] sources at (xs, 0) & (-xs, 0)
yd = 3E-2;	%[m] detector at (xd, yd)
xd = (-3:0.02:3)*1E-2; %[m]

r1 = sqrt((xd - xs).^2 + yd.^2);	% distance b/t -src & detector
U1 = -exp(i*k*r1)./(4*pi*c*D*r1); % negative src

r2 = sqrt((xd + xs).^2 + yd.^2);	% distance b/t +src & detector
U2 = exp(i*k*r2)./(4*pi*c*D*r2);

figure(1)
subplot(3,1,1)
plot([-xs xs]*1E2, [0, 0], '*', [0], [3], 'o', [0 0], [0 3])
text(-xs*1E2, 0.5, '+Source')
text(+xs*1E2, 0.5, '-Source')
text(0, 2.5, 'Scanning Detector')
axis([-3 3 0 3])
xlabel('Source & Detector Positions [cm]')
ylabel('y [cm]')
title('Null Line')

subplot(3,1,2)
plot(xd*1E2, abs(U1+U2))
xlabel('Detector Position [cm]')
ylabel('Amplitude')

subplot(3,1,3)
plot(xd*1E2, unwrap(angle(U1+U2))*180/pi)
xlabel('Detector Position [cm]')
ylabel('Angle [deg]')
grid

figure(2)
r = (1:1:20)*1E-2;
U = exp(i*k*r)./(4*pi*c*D*r);
subplot(2,1,1)
semilogy(r*1E2, abs(U))
xlabel('Source-Detector Distance [cm]')
ylabel('Amplitude')
title('Propagation of PDW')

subplot(2,1,2)
plot(r*1E2, unwrap(angle(U))*180/pi)
xlabel('Source-Detector Distance [cm]')
ylabel('Angle [deg]')
grid
