% Rayleigh scattering
% Use SI units

diameter=input('Diameter of sphere in nm(e.g., 20):')*1e-9;
radius=diameter/2;
lambda=input('Wavelength in nm(e.g., 400):')*1e-9;
n_sphere=input('Refractive index of sphere (e.g., 1.57):');
n_background=input('Refractive index of background (e.g., 1.33):');
w_sphere=input('Specific weight of sphere(e.g., 1.05 g/cc):')*1e-3/(1e-2)^3;
w_background=input('Specific weight of background(e.g., 1.0 g/cc):')*1e-3/(1e-2)^3;
concentration=input('Concentration by weight (e.g., 1e-5):');

k=2*pi*n_background/lambda
x=k*radius
n_rel=n_sphere/n_background

Qs = 8*x^4/3*abs((n_rel^2 - 1)/(n_rel^2 + 2))^2
sigma_s=Qs*pi*radius^2

vol_sphere = 4*pi/3*radius^3
N_s=concentration*w_background/(vol_sphere*w_sphere)
mu_s=N_s*sigma_s

% Output results
{'wavelength[nm]','Qs [-]','mus [/cm]'; lambda*1e9, Qs, mu_s/1e2}