%Accessory File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study'' - 2009-01-07
%
%Takes the following values
%idlpts - a vector of one dimensional observations
%x and y - together specify the kernel density estimate function F(.)
%          computed from the vector of data in idlpts
%percent - see below
%
%The number outputted is the smallest number such that 
%   F[mean(idltpts)+percent]-F[mean(idlpts)-percent]>=.95
%where F is the density represented by x and y
function [percent_bar] = percent_bar(idlpts, x, y, percent);

%compute size of discrete intervals of density function;
spreadint=x(2)-x(1);

%mean of the data vector
idlmean=mean(idlpts);

%compute the output
stop=0;
spread=0;
while (stop==0)
    spread=spread+spreadint;
    region=(x<=idlmean+spread)&(x>=idlmean-spread);
    prop=spreadint*sum(y(region))
     
    if (prop>=percent)
        stop=1;
    end;
end;

percent_bar=[idlmean spread];
