%Program File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study - 2009-01-07
%
%Generates a simulated legislative session for the legislators located in the matrix
%"legislator"
%
%A description of the function inputs may be found in SimPrograms_Guide.PDF
%
%The output is an (N+3) by T matrix with the following columns
%COL1 - the status quo on vote T
%COL2 - the bill on vote T. if the status quo is located in the gridlock interval
%       then this will be set to -10
%COL3 - percentage of individual votes which are correct on the roll call
%COL4 TO COL(N+3) - simulated votes for each legislator. if gridlock then
%                   vote is set to -10

function [generate_session] = generate_session(legislators, which_model, l_piv, r_piv, p, votedist, sigma, t, sqdist, lpoint, supplength);

n=length(legislators); %number of legislators
rollcalls=zeros(t,n); %placeholder for votes;

%cycle through status quo points
for i=1:1:t;
    
     %draw a status quo point
     q(i)=draw_sq(sqdist,lpoint,supplength);
     
     %draw the bill from the complete information game
     y(i)=draw_bill(l_piv, r_piv, p, q(i), which_model);  

     %draw the votes conditional on the status quo, the bill, and
     %the random utility shock distribution
     rollcalls(i,:)=draw_votes(legislators,q(i),y(i),votedist,sigma)';
    
     %compute the errorless votes
     p_votes=draw_votes(legislators,q(i),y(i),0,sigma)';
     
     %compute the percentage of correct votes
     p_correct(i)=sum(1*(p_votes==rollcalls(i,:)))/n;
     
end;

generate_session=[q' y' p_correct' rollcalls];
