%Program File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study - 2009-01-07
%
%Generates estimated ideal points for the legislators located in the matrix
%"legislator" from z_iter separate legislative sessions of length t. 
%
%A description of the function inputs may be found in SimPrograms_Guide.PDF
%
%The output is an (N+4) by T matrix with the following columns
%COL1 - number of status quo points which actually see a floor vote
%COL2 - number of bills which successfully pass
%COL3 - percentage of individual votes which are correct
%COL4 - classification success of the unidimensional ideal point estimates
%COL5 TO COL(N+4) - estimated ideal points for the N legislators
%

function [generate_runs] = generate_runs(legislators, which_model, l_piv, r_piv, p, votedist, sigma, t, sqdist, lpoint, supplength, z_iter, which_votes);
                           
%---------------------SETUP ACCESSORY VARIABLES---------------------------;
leftmost=legislators(1,:);    %leftmost legislator
rightmost=legislators(end,:); %rightmost legislator
n=length(legislators);        %number of legislators

%placeholders
idl_ests=zeros(z_iter,n);
num_srolls=zeros(z_iter,1);
num_fvotes=zeros(z_iter,1);
perc_correct=zeros(z_iter,1);
class_success=zeros(z_iter,1);
%-------------------------------------------------------------------------;


%---------------------RUN LEGISLATIVE SESSIONS----------------------------;
    for z=1:1:z_iter;
       
        %compute the simulated votes in the current legislative session
        output=generate_session(legislators, which_model, l_piv, r_piv, p, votedist, sigma, t, sqdist, lpoint, supplength);
          
        
        floor_votes=(output(:,2)~=-10); %identify which status quo points
                                        %received a floor vote
        succ_rolls=(sum(output(:,4:end),2)/n)>=.5; %identify successul roll calls
        succ_rolls=(floor_votes & succ_rolls); 
        
        %If which_votes parameter is 1 filter out unsuccessful floor votes
        %prior to estimation
        if (which_votes==1)
             filtered_rolls=output(succ_rolls,4:end);
        else
            filtered_rolls=output(floor_votes,4:end);
        end;

        %estimate ideal points from the simulated data
        idl_est_output=estimate_idl(filtered_rolls,legislators(:,1),leftmost,rightmost)';
        idls_ests(z,:)=idl_est_output(2:end)';
                
        %compute number of floor votes and successful roll calls
        num_fvotes(z,1)=sum(floor_votes);
        num_srolls(z,1)=sum(succ_rolls);
               
        %compute percentage correct votes over successful final passage rolls
        perc_correct(z,1)=sum(output(succ_rolls,3))/sum(succ_rolls);
        
        %compute classification success of ideal points
        class_success(z,1)=idl_est_output(1);  
        
    end;

    
    generate_runs=[num_fvotes num_srolls perc_correct class_success idls_ests];
%---------------------------------------------------------------------;

