%Program File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study - 2009-01-07
%
%Draws legislator votes conditional on the agenda and the distribution of
%the random utility shocks. 1 is ``yea'' , 0 is ``nay'', and -10 means
%the vote was gridlocked
%
%Takes the following parameters
%L - an n by 3 matrix where n is the number of legislators. must be presorted
%    by rank. the second column must contain the ideal points
%q - location of the status quo
%y - bill location
%dist - distribution of random utility shocks, takes two values
%   1 - normally distributed shock with variance sigma
%   2 - uniformly distributed shock. when sigma=1 the shock support is set
%       to be the minimum variance shock generating voting probabilities strictly
%       interior to [0,1] for all legislators, conditional on q and y. hence the
%       shocks will be heteroscedastic across votes
%       sigma then scales the shock up or down as a multiplier
%sigma - accessory variable for ``dist''
%
%Function returns an n length vector of votes
%

function [draw_votes] = draw_votes(L,q,y,dist,sigma);

n=length(L);

%if gridlock then specify the votes to be -10
if (y==-10)
    draw_votes=ones(length(L),1)*-10;
    
else
    %normal shocks
    if(dist==1) 
        utils=-(L(:,2)-y).^2-(-(L(:,2)-q).^2)+sigma*randn(n,1);

    %uniform shocks
    elseif(dist==2)
        
        %compute utility differences
        utils=-(L(:,2)-y).^2-(-(L(:,2)-q).^2);
        
        %compute minimum and maximum utility differences
        minfor=min(utils);
        maxfor=max(utils);

        %compute half the length of the uniform shock support
        halfsupp=max(abs(minfor),abs(maxfor));
        
        %draw the uniform shocks for each legislator
        ushocks=-halfsupp+rand(n,1)*2*halfsupp; %make symmetric
        
        %compute final utility
        utils=utils+sigma*ushocks;
        
    %perfect voting, no shocks
    else        
        utils=-(L(:,2)-y).^2-(-(L(:,2)-q).^2);
    end;
    
    %compute final votes, ties broken in favor of bill
    draw_votes=(utils>=0);
end;

    
                


    