%Program File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study - 2009-01-07
%
%Draws a status quo point from a uniform distribution whose lower bound is
%``lpoint'' and with support length ``supplength''

function [draw_sq] = draw_sq(sqdist,lpoint,supplength);

if (sqdist==1)

   sqpoint=lpoint+rand(1,1)*supplength;
else
   sqpoint=-(1/2)+2*rand(1,1); %draw a uniform random status quo point on [-1/2,3/2];
end;

draw_sq=sqpoint;