%Program File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study - 2009-01-07
%
%Computes the bill prediction for the complete information game specified
%by the inputs. if there is gridlock then bill prediction set at -10
%
%INPUTS
%l_piv - the ideal point of leftmost pivot in the pivot game
%r_piv - the ideal point of the rightmost pivot in the pivot game
%p     - the ideal point of the proposer
%q     - the status quo point
%
%which_model    - takes three values
%   1 - proposer acts as a Romer Rosenthal agenda setter
%   2 - pivots act as gatekeepers and if choose not to gatekeep proposer
%       proposes ideal point
%   3 - proposer proposes own ideal point without restriction

function [draw_bill] = draw_bill(l_piv, r_piv, p, q, which_model);

%-------------------AGENDA SETTER GAME----------------------------;
if (which_model==1)
    %if status quo point is in gridlock interval, gridlock 
    if (q>=l_piv) & (q<=r_piv)
        y=-10;
    else
        %compute agenda setter's ideal bill
        if (q>=r_piv) & (q<=2*r_piv-p)     %sq between right pivot and its reflection point
            y=2*r_piv-q;                  %bill is reflection point of sq over veto pivot
        elseif (q<=l_piv) & (q>=2*l_piv-p) %sq between left pivot and its reflection point
            y=2*l_piv-q;                  %bill is reflection point of sq over left pivot 
        else  
            y=p;                     %sq outside of reflection pts interval, bill is median
        end;
    end;
    
%-------------------GATEKEEPER GAME----------------------------;
elseif (which_model==2)
    %if a pivot prefers status quo to proposer's ideal point 
    if (q>=2*l_piv-p) & (q<=2*r_piv-p)
        y=-10;  %gridlock
    else
        y=p;    %proposer proposes ideal point
    end;
    
%-------------------MEDIAN PROPOSER GAME----------------------------;
elseif (which_model==3)
    y=p;    %proposer proposes own ideal point
else
    y=p;
end;

draw_bill=y;