%Program File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study - 2009-01-07
%
%-This code is nearly identical to ``Generate_Output_Uniform_House''
%whose documentation should be used as a reference
%
%However, instead of running run z_iter legislative sessions of length t
%it runs one long legislative session in order to compute the average 
%probability that a vote is will be successful for each specification of 
%the model.
%
%These probabilities are then outputted in order to calibrate the simulation
%runs to hit an expected number of successful roll call votes in each session
%equal to 241------;


clear all;
close all;
state = 16483;
rand('state', state);
randn('state',state);

congress=106;                   %106th house
sqdist=1;                           %uniform to accommodate hurrah votes
votedist=2;                          %shock dist for votes, uniform
t=100000;


%READ IN 106TH HOUSE
rawdata=dlmread('real_houses.csv');
rawdata=[rawdata(:,1) rawdata(:,2) rawdata(:,6) rawdata(:,5)];
legislators=rawdata(rawdata(:,1)==congress,2:4);
legislators=sortrows(legislators,2);
leftmost=legislators(1,:);
rightmost=legislators(end,:);     
n=length(legislators);

%------------------------

%------COMPUTE MODEL INFORMATION;
pivots=calculate_pivots(legislators);
supplength=2*(legislators(end,2)-legislators(1,2));
lpoint=2*legislators(1,2)-pivots(8); %reflection pt around leftmost legislator of median
%---------------------------------------


%RUNS INITIAL VALUES AND PERMUTATION VALUES
s_iter=1;
startpt=1;
endpt=1;

for s=1:1:s_iter; sigma(s)=startpt+(s-1)*(endpt-startpt)/max((s_iter-1),1); end;

%--------------

%BEGIN SIMULATIONS - PARTY CARTEL MODEL;
l_piv=pivots(8);  r_piv=pivots(6);  p=pivots(8); %set pivots 
which_model=2;                       %gatekeeper model
s=zeros(1,s_iter);

prob_succ_PC=zeros(s_iter,2);
prob_succ_MV=zeros(s_iter,2);

for s=1:1:s_iter;    
       output=generate_session(legislators, which_model, l_piv, r_piv, p, votedist, sigma(s), t, sqdist, lpoint, supplength);
       floor_votes=(output(:,2)~=-10);
       succ_rolls=(sum(output(:,4:end),2)/n)>=.5;
       succ_rolls=(floor_votes & succ_rolls);
       
       prob_succ_PC(s,:)=[sum(floor_votes)/t sum(succ_rolls)/sum(floor_votes)];
end;

%BEGIN SIMULATIONS - UNCONSTRAINED MEDIAN MODEL;
which_model=3;                      

for s=1:1:s_iter;
       output=generate_session(legislators, which_model, l_piv, r_piv, p, votedist, sigma(s), t, sqdist, lpoint, supplength);
       floor_votes=(output(:,2)~=-10);
       succ_rolls=(sum(output(:,4:end),2)/n)>=.5;
       succ_rolls=(floor_votes & succ_rolls);
       
       prob_succ_MV(s,:)=[sum(floor_votes)/t sum(succ_rolls)/sum(floor_votes)];
end;

dlmwrite('calibration/prob_succ_un_PC',prob_succ_PC);
dlmwrite('calibration/prob_succ_un_MV',prob_succ_MV);