%Program File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study - 2009-01-07
%
%-Accessory file which computes the necessary pivots from the n by 3 matrix
%-containing the legislator numerical labels in the first column, ideal points
%-in the second column, and party in the third column-------
%
%-For simplicity it is always assumed that the president is to the right of
%-the median and exterior to the veto pivot;
%
%Output is a single row vector with the following columns.
%COL1 - Rank of filibuster pivot
%COL2 - Ideal point of filibuster pivot
%COL3 - Rank of veto pivot
%COL4 - Ideal point of veto pivot
%COL5 - Rank of majority party median 
%COL6 - Ideal point of majority party median 
%COL7 - Rank of chamber median
%COL8 - Ideal point of chamber median

function [calculate_pivots] = calculate_pivots(legislators);

n=length(legislators);
indices=(1:1:n);

%compute pivot ranks. assume in even numbered body that veep to right
%of median breaks tie, which is consistent with the veto pivot assumption
%that the president is to the right of the median 
f_piv_index=n-ceil(n*(3/5))+1;
v_piv_index=ceil(n*(2/3));
med_index=ceil((n+1)/2);
    

%compute pivot ideal points;
f_piv=legislators(f_piv_index,2);        
v_piv=legislators(v_piv_index,2);
med=legislators(med_index,2);    


%-------------------compute majority party median rank and ideal point----;
%compute identity of majority party
majparty=1*((sum(legislators(:,3)==100)/n)>.5);
majparty=100*majparty+200*(1-majparty);

%select out majority party legislators
majparty_legislators=legislators(legislators(:,3)==majparty,:);

%compute size of majority party
majparty_size=length(majparty_legislators);

%compute rank of majority party median
majparty_med_index=majparty_legislators(floor((majparty_size+1)/2),1);
majparty_med_index=indices(legislators(:,1)==majparty_med_index);

%compute ideal point of majority party median
majparty_med=legislators(majparty_med_index,2);

clear majparty majparty_legislators majparty_size;
%-------------------------------------------------------------------------;


%output
calculate_pivots=[f_piv_index f_piv v_piv_index v_piv majparty_med_index majparty_med med_index med];
     