%Program File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study'' - 2009-01-07
%
%Creates Figure 1

clear

%---------------------PRELIMINARIES---------------------------------------;
%bill
y=0;
%status quo 1
q1=-1/2;
%status quo 2
q2=1/2;

%legislators to plot
L=[-1.1:.001:1.1]';

%utility differences for each status quo
utils_q1=-(L-y).^2-(-(L-q1).^2);
utils_q2=-(L-y).^2-(-(L-q2).^2);

%placeholders
probs_q1=zeros(length(L),3);
probs_q2=zeros(length(L),3);

%compute yea probabilities for all legislators, q1;
probs_q1(:,1)=normcdf(utils_q1,0,1); %high error
probs_q1(:,2)=normcdf(utils_q1,0,.175); %low error
probs_q1(:,3)=normcdf(utils_q1,0,.0000000000001); %no error

%compute yea probabilities for all legislators, q2;
probs_q2(:,1)=normcdf(utils_q2,0,1); %high error
probs_q2(:,2)=normcdf(utils_q2,0,.175); %low error
probs_q2(:,3)=normcdf(utils_q2,0,.0000000000001); %no error

%create plot labels
labels=['High Error';'Low Error ';'Errorless ']
labels=cellstr(labels)
%-------------------------------------------------------------------------;


%------------------GENERATE PLOTS FOR Q_1---------------------------------;
%cycle through levels of error
for s=1:1:3;
    
    subplot(3,3,3+s)

    %set background color to white and hide matlab generated x axis
    set(gcf,'Color','w')
    set(gca,'Color','white','XColor','white')

    hold on;

    %plot ``yea'' probabilities over entire policy space     
    plot(L,probs_q1(:,s),'LineStyle','--','LineWidth',1.5,'Color','b');

    %compute ``yea'' probabilities for 3 legislators in example
    x1prob=probs_q1(L==-1,s);
    x2prob=probs_q1(L==0,s);
    x3prob=probs_q1(L==1,s);


    %draw x axis at y=0 
    line(xlim,[0 0],'Color','k','LineWidth',1.25);

    %draw verticle line at the location of the cutpoint
    line([(y+q1)/2 (y+q1)/2],[0 1.1],'LineStyle',':','Color',[.25 .25 .25],'LineWidth',1);


    %----------demarcate yea probabilities of three legislators on y axis----;
    line([-1.1 -1],[x1prob x1prob],'Color','k','LineStyle','-.','Color',[.5 .5 .5]);
    line([-1 -1],[0 x1prob],'Color','k','LineStyle','-.','Color',[.5 .5 .5]);
    scatter(-1.1,x1prob,12,'Marker','o','MarkerFaceColor','k','MarkerEdgeColor','k');

    line([-1.1 0],[x2prob x2prob],'Color','k','LineStyle','-.','Color',[.5 .5 .5]);
    line([0 0],[0 x2prob],'Color','k','LineStyle','-.','Color',[.5 .5 .5]);
    scatter(-1.1,x2prob,12,'Marker','o','MarkerFaceColor','k','MarkerEdgeColor','k');

    line([-1.1 1],[x3prob x3prob],'Color','k','LineStyle','-.','Color',[.5 .5 .5]);
    line([1 1],[0 x3prob],'Color','k','LineStyle','-.','Color',[.5 .5 .5]);
    scatter(-1.1,x3prob,12,'Marker','o','MarkerFaceColor','k','MarkerEdgeColor','k');
    %-------------------------------------------------------------------------;

    
    %--------plot ideal points and labels of three legislators, status quo----;
    scatter(-1,0,44,'Marker','o','MarkerFaceColor','red','MarkerEdgeColor','red');
    text(-1,-.01,'x_{1}','HorizontalAlignment','center','VerticalAlignment','top','FontSize',8);
        
    scatter(0,0,44,'Marker','o','MarkerFaceColor','red','MarkerEdgeColor','red');
    text(0,-.01,'x_{2}=b','HorizontalAlignment','center','VerticalAlignment','top','FontSize',8);
    
    scatter(1,0,44,'Marker','o','MarkerFaceColor','red','MarkerEdgeColor','red');
    text(1,-.01,'x_{3}','HorizontalAlignment','center','VerticalAlignment','top','FontSize',8);
    
    scatter(q1,0,44,'Marker','^','MarkerFaceColor','green','MarkerEdgeColor','green');
    text(q1,0,'q_1','HorizontalAlignment','center','VerticalAlignment','top','FontSize',8);
    %-------------------------------------------------------------------------;
    
    
    %----draw arrow and label for cutpoint--------------------------------;
    [px1 py1]=dsxy2figxy(gca,-7/16+.01,.8);
    [px2 py2]=dsxy2figxy(gca,(y+q1)/2,.8);
    annotation('arrow',[px1 px2],[py1 py2],'HeadStyle','vback3','LineWidth',.5,'HeadWidth',5,'HeadLength',5);
    text(-7/16,.8,'cutpoint','HorizontalAlignment','right','FontSize',8);            
    %---------------------------------------------------------------------;

    
    %----formatting-------------------------------------------------------;
    title(labels(s),'fontsize',10);
    set(gca,'Xlim',[-1.1 1.1])
    ylabel('P(yea | q_1)','fontsize',8)
    set(gca,'Ylim',[0 1.05])
    set(gca,'fontsize',8)
    %---------------------------------------------------------------------;
    
    hold off;

end;
%-------------------------------------------------------------------------;


%------------------GENERATE PLOTS FOR Q_2---------------------------------;
%cycle through levels of error
for s=1:1:3;
    
    subplot(3,3,6+s)

    %set background color to white and hide matlab generated x axis
    set(gcf,'Color','w')
    set(gca,'Color','white','XColor','white')

    hold on;
    
    %plot ``yea'' probabilities over entire policy space   
    plot(L,probs_q2(:,s),'LineStyle','--','LineWidth',1.5,'Color','b');

    %compute ``yea'' probabilities for 3 legislators in example
    x1prob=probs_q2(L==-1,s);
    x2prob=probs_q2(L==0,s);
    x3prob=probs_q2(L==1,s);

    %draw x axis at y=0 
    line(xlim,[0 0],'Color','k','LineWidth',1.25);

    %draw verticle line at the location of the cutpoint
    line([(y+q2)/2 (y+q2)/2],[0 1.1],'LineStyle',':','Color',[.25 .25 .25],'LineWidth',1);


    %----------demarcate yea probabilities of three legislators on y axis----;
    line([-1.1 -1],[x1prob x1prob],'Color','k','LineStyle','-.','Color',[.5 .5 .5]);
    line([-1 -1],[0 x1prob],'Color','k','LineStyle','-.','Color',[.5 .5 .5]);
    scatter(-1.1,x1prob,12,'Marker','o','MarkerFaceColor','k','MarkerEdgeColor','k');


    line([-1.1 0],[x2prob x2prob],'Color','k','LineStyle','-.','Color',[.5 .5 .5]);
    line([0 0],[0 x2prob],'Color','k','LineStyle','-.','Color',[.5 .5 .5]);
    scatter(-1.1,x2prob,12,'Marker','o','MarkerFaceColor','k','MarkerEdgeColor','k');

    line([-1.1 1],[x3prob x3prob],'Color','k','LineStyle','-.','Color',[.5 .5 .5]);
    line([1 1],[0 x3prob],'Color','k','LineStyle','-.','Color',[.5 .5 .5]);
    scatter(-1.1,x3prob,12,'Marker','o','MarkerFaceColor','k','MarkerEdgeColor','k');
    %-------------------------------------------------------------------------;    

    %--------plot ideal points and labels of three legislators, status quo----;
    scatter(-1,0,44,'Marker','o','MarkerFaceColor','red','MarkerEdgeColor','red');
    text(-1,-.01,'x_{1}','HorizontalAlignment','center','VerticalAlignment','top','FontSize',8);

    scatter(0,0,44,'Marker','o','MarkerFaceColor','red','MarkerEdgeColor','red');
    text(0,-.01,'x_{2}=b','HorizontalAlignment','center','VerticalAlignment','top','FontSize',8);

    scatter(1,0,44,'Marker','o','MarkerFaceColor','red','MarkerEdgeColor','red');
    text(1,-.01,'x_{3}','HorizontalAlignment','center','VerticalAlignment','top','FontSize',8);

    scatter(q2,0,44,'Marker','^','MarkerFaceColor','green','MarkerEdgeColor','green');
    text(q2,0,'q_2','HorizontalAlignment','center','VerticalAlignment','top','FontSize',8);
    %-------------------------------------------------------------------------;

    
    %----draw arrow and label for cutpoint--------------------------------;
    [px1 py1]=dsxy2figxy(gca,7/16+.012,.8);
    [px2 py2]=dsxy2figxy(gca,(y+q2)/2,.8);
    annotation('arrow',[px1 px2],[py1 py2],'HeadStyle','vback3','LineWidth',.5,'HeadWidth',5,'HeadLength',5);
    text(7/16,.8,'cutpoint','HorizontalAlignment','left','FontSize',8); 
    %---------------------------------------------------------------------;
            

    %----formatting-------------------------------------------------------;
    set(gca,'Xlim',[-1.1 1.1])
    ylabel('P(yea | q_2)','fontsize',8)
    set(gca,'Ylim',[0 1.05])
    set(gca,'fontsize',8)
    %---------------------------------------------------------------------;
    
    hold off;

end;

%output
set(gcf,'PaperPosition', [0 0 8.5 8.5]);
print -dpdf 'Figure1.pdf'

