%Program File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study'' - 2009-01-07
%
%Computes mean correlation coefficients for party cartel and median
%proposer models in the uniform case

clear

%----------------READ IN TRUE IDEAL POINTS, COMPUTE PIVOTS----------------;
legislators_data=dlmread('outuniform\legislators');
legislators=legislators_data(:,:);
n=length(legislators);

pivots=calculate_pivots(legislators);

med_index=pivots(7);
med=pivots(8);
majparty_med_index=pivots(5);
majparty_med=pivots(6);

r_blockzone=majparty_med;

blockzone_leg=(legislators(:,2)>=med)&(legislators(:,2
%-------------------------------------------------------------------------;

%--------------------SETUP SIMULATION PERMUTATIONS------------------------;
s_iter=1;
startpt=1;
endpt=1;

for s=1:1:s_iter; sigma(s)=startpt+(s-1)*(endpt-startpt)/max((s_iter-1),1); end;
%-------------------------------------------------------------------------;


%------------------COMPUTE MEAN CORRELATION COEFFICIENTS------------------;
mean_idls_PC=zeros(n,s_iter);

for s=1:1:1;

    %read in party cartel data;
    dataPC=dlmread(strcat('outuniform\outputPC_Uniform_',int2str(s)));
    dataPC=dataPC(:,5:end); %cut off first four columns
    
    %read in median proposer data; 
    dataMV=dlmread(strcat('outuniform\outputMV_Uniform_',int2str(s)));
    dataMV=dataMV(:,5:end); %cut off first four columns
    
    %mean ideal points
    mean_idls_PC(:,s)=mean(dataPC)';
    mean_idls_MV(:,s)=mean(dataMV)';
    
    %select out blockzone legislators
    idlpts_BZ_PC=dataPC(:,blockzone_leg);
    idlpts_BZ_MV=dataMV(:,blockzone_leg);
    idlpts_BZ=legislators(blockzone_leg,2);
    
    
    %blockzone correlations per run
    corrs_BZ_PC=corr(idlpts_BZ_PC',idlpts_BZ);
    corrs_BZ_MV=corr(idlpts_BZ_MV',idlpts_BZ);
    
    %mean correlation of blockzone legislators
    mean_corrs_BZ_PC(s)=mean(corrs_BZ_PC)
    mean_corrs_BZ_MV(s)=mean(corrs_BZ_MV)

    %correlation of true values with means, blockzone legislators
    corr_ofmeans_BZ_PC(s)=corr(mean_idls_PC(blockzone_leg,s),idlpts_BZ);
    corr_ofmeans_BZ_MV(s)=corr(mean_idls_MV(blockzone_leg,s),idlpts_BZ);

    
    %-----------compute same statistics for all legislators----------;
    
    %all legislator correllations per run
    corrs_PC=corr(dataPC',legislators(:,2));
    corrs_MV=corr(dataMV',legislators(:,2));
    
    %mean correllation all
    mean_corrs_PC(s)=mean(corrs_PC)
    mean_corrs_MV(s)=mean(corrs_MV)

    %correllation with means, all
    corr_ofmeans_PC(s)=corr(mean_idls_PC(:,s),legislators(:,2));
    corr_ofmeans_MV(s)=corr(mean_idls_MV(:,s),legislators(:,2));

end;

dlmwrite('outuniform\mean_corrs_BZ_PC',[sigma' mean_corrs_BZ_PC']);
dlmwrite('outuniform\mean_corrs_BZ_MV',[sigma' mean_corrs_BZ_MV']);


%----------------------END OF FILE IS HERE--------------------------;




%otherwise interesting plots - a lower correllation of BZ legislators does
%*not* mean noiser estimates!
leglabels=(1:1:n)';
hold on;
scatter(leglabels,dataPC(1,:)')
scatter(leglabels,legislators(:,2)')
figure(2)
hold on;
scatter(leglabels(blockzone_leg),legislators(blockzone_leg,2)')
scatter(leglabels(blockzone_leg),dataPC(1,blockzone_leg)')
figure(3)
hold on;
scatter(leglabels(~blockzone_leg),legislators(~blockzone_leg,2)')
scatter(leglabels(~blockzone_leg),dataPC(1,~blockzone_leg)')
figure(4)
hold on;
scatter(leglabels(50:157),legislators(50:157,2)')
scatter(leglabels(50:157),dataPC(1,50:157)')


%---------------testcorr-------------------;
testcorrs_PC=corr(dataPC(:,50:157)',legislators(50:157,2));
testcorrs_MV=corr(dataMV(:,50:157)',legislators(50:157,2));
    
%mean correllation all
testmean_corrs_PC(s)=mean(testcorrs_PC)
testmean_corrs_MV(s)=mean(testcorrs_MV)

test2corrs_PC=corr(dataPC(:,221:328)',legislators(221:328,2));
test2corrs_MV=corr(dataMV(:,221:328)',legislators(221:328,2));
    
%mean correllation all
test2mean_corrs_PC(s)=mean(test2corrs_PC)
test2mean_corrs_MV(s)=mean(test2corrs_MV)

    
