%Program File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study'' - 2009-01-07
%
%Computes and plots mean percentage correct voting and classification
%success as a function of \sigma for the party cartel and median proposer
%simulations

clear

%----------------READ IN TRUE IDEAL POINTS, COMPUTE PIVOTS----------------;
legislators_data=dlmread('outnormal\legislators');
legislators=legislators_data(:,:);

pivots=calculate_pivots(legislators);

med=pivots(8);
majparty_med=pivots(6);

r_blockzone=majparty_med;

blockzone_leg=(legislators(:,2)>=med)&(legislators(:,2)<=r_blockzone);
%-------------------------------------------------------------------------;


%--------------------SETUP SIMULATION PERMUTATIONS------------------------;
s_iter=16;
startpt=0;
endpt=.60;

for s=1:1:s_iter; sigma(s)=startpt+(s-1)*(endpt-startpt)/max((s_iter-1),1); end;
%-------------------------------------------------------------------------;


%--------------------COMPUTE DATA-----------------------------------------;
for s=1:1:s_iter;
    
    %party cartel;
    dataPC=dlmread(strcat('outnormal\outputPC_',int2str(s)));
    mean_correct_PC(s)=mean(dataPC(:,3));
    mean_class_PC(s)=mean(dataPC(:,4));
    
    %median proposer
    dataMV=dlmread(strcat('outnormal\outputMV_',int2str(s)));
    mean_correct_MV(s)=mean(dataMV(:,3));
    mean_class_MV(s)=mean(dataMV(:,4));
end;
%-------------------------------------------------------------------------;


%---------------------CREATE PLOT-----------------------------------------;
figure(1);
hold on;
plot(sigma(1:s_iter)',mean_correct_PC(1:s_iter)','r','LineWidth',1.5);
plot(sigma(1:s_iter)',mean_class_PC(1:s_iter)','r--','LineWidth',1.5);
plot(sigma(1:s_iter)',mean_correct_MV(1:s_iter)','g','LineWidth',1.5);
plot(sigma(1:s_iter)',mean_class_MV(1:s_iter)','g--','LineWidth',1.5);
legend('% Correct, Run 1 (Party Cartel)','% Classified, Run 1 (PC)','% Correct, Run 2 (Median Proposer)','% Classified, Run 2 (MP)');
set(gca,'Xlim',[0 endpt])
set(gca,'fontsize',14)
xlabel('\sigma','fontsize',14)
hold off;
%-------------------------------------------------------------------------;

%output figure
saveas(1,'outnormal\Class_Success.pdf');

%output data
dlmwrite('outnormal\class_stats',[sigma' mean_correct_PC' mean_class_PC' mean_correct_MV' mean_class_MV']);
