%Program File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study'' - 2009-01-07
%
%Computes mean estimated ideal points, 95% probability interval, and true
%ideal points as a function of rank in the uniform case 

clear

%---------------------SET PARAMETERS-------------------------------------;
z_iter=2000;  %number of sessions in each set
percent=.95;  %probability associated with interval
h=.005; %bandwidth parameter for kernel density estimate
x=[-3:.0001:3]; %values for ksdensity estimate
x=round(x*10000)/10000; %required for reasons i cannot fathom
%-------------------------------------------------------------------------;


%----------------READ IN TRUE IDEAL POINTS, COMPUTE PIVOTS----------------;
legislators_data=dlmread('outuniform\legislators');
legislators=legislators_data(:,:);
n=length(legislators);

pivots=calculate_pivots(legislators);

med_index=pivots(7);
med=pivots(8);
majparty_med_index=pivots(5);
majparty_med=pivots(6);

r_blockzone=majparty_med;

blockzone_leg=(legislators(:,2)>=med)&(legislators(:,2
%-------------------------------------------------------------------------;


%--------------------SETUP SIMULATION PERMUTATIONS------------------------;
s_iter=1;
startpt=1;
endpt=1;

for s=1:1:s_iter; sigma(s)=startpt+(s-1)*(endpt-startpt)/max((s_iter-1),1); end;
%-------------------------------------------------------------------------;


%--------------------PLACEHOLDER VARIABLES--------------------------------;
Leg_Density_PC=zeros(length(x),n);
Leg_PRegion_PC=zeros(2,n);

Leg_Density_MV=zeros(length(x),n);
Leg_PRegion_MV=zeros(2,n);
%-------------------------------------------------------------------------;


%----------------COMPUTE MEANS AND INTERVALS FOR PLOTS--------------------;
for s=1:1:s_iter;

    %read in party cartel data;
    dataPC=dlmread(strcat('outuniform\outputPC_Uniform_',int2str(s)));
    dataPC=dataPC(:,5:end); %cut off first four columns
    
    %read in median proposer data; 
    dataMV=dlmread(strcat('outuniform\outputMV_Uniform_',int2str(s)));
    dataMV=dataMV(:,5:end); %cut off first four columns
    
    %compute probability intervals for each legislator;
    for l=1:1:n;
   
        %compute kernel densities for each legislator
        for i=1:1:length(x);  Leg_Density_PC(i,l)=sum(normpdf((dataPC(:,l)-x(i))/h,0,1))/(h*z_iter);   end;
        for i=1:1:length(x);  Leg_Density_MV(i,l)=sum(normpdf((dataMV(:,l)-x(i))/h,0,1))/(h*z_iter);   end;
        
        %compute interval
        Leg_PRegion_PC(:,l)=percent_bar(dataPC(:,l), x, Leg_Density_PC(:,l), percent)';
        Leg_PRegion_MV(:,l)=percent_bar(dataMV(:,l), x, Leg_Density_MV(:,l), percent)';
    
    end;
    
end;
%-------------------------------------------------------------------------;


%----------OUTPUT MEANS AND PROBABILITY INTERVALS ------------------------;
dlmwrite('outuniform\mean_idls_PC',[legislators(:,2) Leg_PRegion_PC(1,:)' Leg_PRegion_PC(2,:)']);
dlmwrite('outuniform\mean_idls_MV',[legislators(:,2) Leg_PRegion_MV(1,:)' Leg_PRegion_MV(2,:)']);
%-------------------------------------------------------------------------;


%----------------GENERATE PLOT--------------------------------------------;
for s=1:1:s_iter;

    leglabels=(1:1:n)';
    
    figure(s);    

    hold on;
    
    %plot mean ideal points
    a=plot(leglabels,Leg_PRegion_PC(1,:)','r','LineWidth',1.5);
    
    %plot interval
    b1=plot(leglabels,(Leg_PRegion_PC(1,:)+Leg_PRegion_PC(2,:))','LineStyle','--','LineWidth',1,'Color',[.25 .25 .25]);
    b2=plot(leglabels,(Leg_PRegion_PC(1,:)-Leg_PRegion_PC(2,:))','LineStyle','--','LineWidth',1,'Color',[.25 .25 .25]);  
    
    %plot true values
    c=plot(leglabels,legislators(:,2),'LineStyle','--','LineWidth',1.5,'Color','b');   %true values;
    
    %plot lines at block zone;
    line([med_index med_index],ylim,'Color','k');
    line([majparty_med_index majparty_med_index],ylim,'Color','k');

    %x and y axis label, font sizes, legend
    xlabel('True Rank','fontsize',14);
    ylabel('Ideal Point','fontsize',14);
    set(gca,'fontsize',14)
    legend([a c b1],'Mean Estimated Ideal Point','True Ideal Point','95 % Band','Location','NorthWest');
    
    hold off;
    
    filename=strcat('outuniform\IdlPt_Means_Uniform_',int2str(s),'.pdf');
    saveas(s,filename);
    
end;


