%Program File for "Theory Driven Bias in Ideal Point Estimates - A Monte
%Carlo Study - 2009-01-07
%
%-GENERATES OUTPUT FOR SIMULATIONS WITH UNIFORMLY DISTRIBUTED SHOCKS-------;

%---------------------SET RANDOM NUMBER GENERATOR KERNEL------------------;
clear all;
close all;
state = 16483;
rand('state', state);
randn('state',state);
%-------------------------------------------------------------------------;


%--------------------SET VARIABLES FOR SIMULATIONS----------------------;
congress=106;                   %draws ideal points from legislators in the 106th house;
target_t=241;                   %sets the expected number of final passage votes in
                                %each legislative session
                                
sqdist=1;                       %sets distribution of status quo points to uniform
votedist=2;                     %sets distribution of voter random utility shocks to uniform
which_votes=1;                  %filters out unsuccessful votes due to idiosyncratic
                                %error prior to ideal point estimation

z_iter=2000;                    %number of legislative sessions to simulate
%-------------------------------------------------------------------------;


%------------READ IN DW-NOMINATE SCORES FROM 106TH HOUSE------------------;
%generates an n by 3 matrix of legislator ideal points. first column is
%numerical labels, 2nd column is ideal points, 3rd column is the party;
rawdata=dlmread('real_houses.csv');
rawdata=[rawdata(:,1) rawdata(:,2) rawdata(:,6) rawdata(:,5)];
legislators=rawdata(rawdata(:,1)==congress,2:4);
legislators=sortrows(legislators,2);
leftmost=legislators(1,:);
rightmost=legislators(end,:);     
n=length(legislators);
%-------------------------------------------------------------------------;


%------COMPUTE LOCATION OF PIVOTS AND DESIRED DISTRIBUTION OF STATUS QUO--;
%POINTS. DISTRIBUTION OF STATUS QUO POINTS IS MINIMUM NECESSARY TO PERMIT
%``HURRAH'' VOTES;
pivots=calculate_pivots(legislators);
supplength=2*(legislators(end,2)-legislators(1,2));
lpoint=2*legislators(1,2)-pivots(8); %reflection pt around leftmost legislator of median
%-------------------------------------------------------------------------;


%-----------------------------------CALIBRATION---------------------------;
%read in estimated probability of vote success in each model;
%note that prob_succ_un_PC is probability of success *conditional* on the
%status quo point being located outside of the blockout zone
prob_succ_un_PC=dlmread('calibration/prob_succ_un_PC');
prob_succ_un_MV=dlmread('calibration/prob_succ_un_MV');


%compute number of status quo points to draw in order to hit target_t
%successful roll calls in every set of simulations;
expected_gridlock=2*(pivots(6)-pivots(8))/supplength;
q_PC=round(target_t./((1-expected_gridlock)*prob_succ_un_PC(:,2)))
q_MV=round(target_t./(prob_succ_un_MV(:,2)))
%-------------------------------------------------------------------------;


%--------------------SETUP MODEL PERMUTATIONS-----------------------------;
%Will run s_iter different sets of simulations each with z_iter legislative
%sessions, starting with sigma=startpt and ending with sigma=endpt, where 
%sigma is the scale of the voter uniform random utility shocks  
s_iter=1;
startpt=1;
endpt=1;

for s=1:1:s_iter; sigma(s)=startpt+(s-1)*(endpt-startpt)/max((s_iter-1),1); end;
%-------------------------------------------------------------------------;


%-------------------SIMULATIONS - PARTY CARTEL MODEL----------------------;
l_piv=pivots(8);  r_piv=pivots(6);  p=pivots(8); %set pivots 
which_model=2;                       %gatekeeper model
s=zeros(1,s_iter);

for s=1:1:s_iter;
    outdata=generate_runs(legislators, which_model, l_piv, r_piv, p, votedist, sigma(s), q_PC(s), sqdist, lpoint, supplength, z_iter, which_votes);
    outputloc=strcat('outuniform/outputPC_Uniform_',int2str(s));
    dlmwrite(outputloc,outdata);
end;
%-------------------------------------------------------------------------;


%-------------------SIMULATIONS - MEDIAN PROPOSER MODEL-------------------;
which_model=3;                       %median can propose anything
s=zeros(1,s_iter);

for s=1:1:s_iter;
    outdata=generate_runs(legislators, which_model, l_piv, r_piv, p, votedist, sigma(s), q_MV(s), sqdist, lpoint, supplength, z_iter, which_votes);
    outputloc=strcat('outuniform/outputMV_Uniform_',int2str(s));
    dlmwrite(outputloc,outdata);
end;

%output legislator ideal points
dlmwrite('outuniform/legislators',legislators);
%-------------------------------------------------------------------------;



