/*
 * Copyright (c) 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Michael Fischbein.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright (c) 1989, 1993\n\
	The Regents of the University of California.  All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)who.c	8.1 (Berkeley) 6/6/93";
#endif /* not lint */

#include <sys/types.h>
#include <sys/file.h>
#include <stdio.h>

#ifndef SYSV
#include <utmp.h>
#else
#include <utmpx.h>
#endif

#ifndef	_PATH_UTMP
#ifndef FREEBSD
#ifdef OSF1
#define	_PATH_UTMP "/var/adm/utmp"
#define UT_NAMESIZE     32
#define UT_LINESIZE     32
#define UT_HOSTSIZE     64 
#else
#ifdef SYSV
#define	_PATH_UTMP "/var/adm/utmpx"
#define UT_NAMESIZE     32
#define UT_LINESIZE     32
#define UT_HOSTSIZE     257 
#else
#define	_PATH_UTMP "/etc/utmp"
#define UT_NAMESIZE    	8 
#define UT_LINESIZE     8
#define UT_HOSTSIZE     16 
#endif
#endif
#endif
#endif

get_tty_src(site)
	char *site;
{
	register char *p;
#ifndef SYSV
	struct utmp usr;
#else
	struct utmpx usr;
#endif

	FILE *ufp;
	char *t, *rindex(), *strcpy(), *strncpy(), *ttyname();
#ifdef SUN5
	char *index();
#endif

	strcpy(site, "(UNKNOWN???)");
	if( !(ufp = fopen(_PATH_UTMP, "r")) )
	  return;

	/* search through the utmp and find an entry for this tty */

	if (p = ttyname(0)) 
	{
		/* strip any directory component */
#ifdef RS6K
		if (t = index(p, '/'))
			p = t + 1;  
		if (t = index(p, '/'))
			p = t + 1;  
#else
#ifdef HPPA
		if (t = index(p, '/'))
			p = t + 1;  
		if (t = index(p, '/'))
			p = t + 1;  
#else
#ifndef	SYSV			
		if (t = rindex(p, '/'))
			p = t + 1;  
#else 
		if (t = index(p, '/'))
			p = t + 1;  
		if (t = index(p, '/'))
			p = t + 1;  
#endif
#endif
#endif
		sprintf(site, "(%-.10s UNKNOWN???)", p);
		while (fread((char *)&usr, sizeof(usr), 1, ufp) == 1)
		  if (usr.ut_name && !strcmp(usr.ut_line, p)) 
		  {
		    if (usr.ut_host)
			sprintf(site, "(%-.*s)", (UT_HOSTSIZE>27)?27:UT_HOSTSIZE, usr.ut_host);
		    return;
		  }
	}
	else
	  strcpy(site, "(TTY UNKNOWN???)");
}
/*end of get_tty_src*/



#ifdef SUN5
/*
	Solaris 2.4 implement index in /usr/ucb/cc
	but we don't want to use it
*/
char *index(p, c)
char *p;
char c;
{
  int cnt;

  while( *(p+cnt) )
  {
    if( *(p+cnt)==c )
      return(p+cnt);
    cnt++;
  }

  return((char*)NULL);
}
/*end of index*/
#endif
