#include <curses.h> 
#include "msg.h"
#include "color.h"                    /* Jones */

#ifndef LINUX
#include <sgtty.h>
#endif

#ifdef LINUX
#include <bsd/sgtty.h>
#endif

#ifdef HPPA
#include <termio.h>
#endif

#ifdef IRIX
#include <sys/ttold.h>
#endif     

#include "pbbs.h"
#include "msg.h"

static char rcsid[]="$Id: term.c,v 1.1 1995/11/11 08:47:27 pbbs Exp pbbs $" ;

#define	META_LEFT	"{#"
#define	META_RIGHT	"#}"

long kkystr() ;

extern char capfn[80] ;

static char finds[100] ;
static long last_s ;


int getstring(x,y,str,len,gmode)
int x ;
int y ;
char *str ;
int len ;
int gmode ;     /*-- 1: normal, 2: password, 3:number --*/
{
  int i=0 ;  int otherwise ;  unsigned int chr ;  char tmp[81] ; 
  int bs ; 
  int ctrl_n=14 ;  struct sgttyb csgttyb; 
  
  ioctl(1, TIOCGETP, &csgttyb);
  bs=csgttyb.sg_erase;

  if((x>=0) && (y>=0))
  {
    move(y,x) ;
    refresh() ;
  }
  
  strcpy(tmp,str) ;
  i=strlen(str) ;
  
  printf("%s",tmp) ;
  fflush(stdout) ;
  
  while(i>=0)
  {
    chr=getch() ;
    otherwise=TRUE ;

    if(ctrl_n==chr)
      continue ;
      
    if(chr==bs)
    {
      otherwise=FALSE ;
      if(i>0)
      {
        printf("%c %c",8,8) ;
        tmp[i--]=0 ;
        fflush(stdout) ;
      }
      else
      {
        /* beep */
      }
    }  
      
    if((chr=='\r') || (chr=='\n'))
    {
      otherwise=FALSE ;
      tmp[i]=0 ;
      break ;
    }  
    
    if(chr==27)
    {
      otherwise=FALSE ;
    }
    
    if(gmode==3)
    {  
      if(!isdigit(chr))
      {
        continue ;
      }
    }    
    
    if(otherwise)
    {
      if(i<len && chr>31)
      {
        if(gmode==2)
          printf("*") ;
        else  
          printf("%c",chr) ;
        tmp[i++]=chr ;
        fflush(stdout) ;
      }
    }  
  }

  strcpy(str,tmp) ;
  return(strlen(tmp)) ;
}

init_terminal()
{
  struct winsize  size ;
  
  initscr() ;
  raw() ;
  noecho() ;
  nonl() ;
  
  ioctl(fileno(stdin), TIOCGWINSZ, (char *) &size) ;
  SCR_ROWS=size.ws_row ;
  SCR_COLS=size.ws_col ;
  
  if( term_mode==1 )
  {
    /*some system rows transmit error*/
    if( SCR_ROWS>26 || SCR_ROWS<23 )
      SCR_ROWS=24 ;

    if( SCR_COLS>90 || SCR_COLS<78 )
      SCR_COLS=79 ;
  }

  if( SCR_ROWS<5 )
      SCR_ROWS=24 ;

  /*force LINES to be 24*/
  SCR_ROWS=24;
}  

end_terminal()
{
  endwin() ;
}

/*--- To search a word ---*/
long search_word(str,word)
/*
    return : -1: not found.
    	    >=0: closest \n.
*/    	    
char *str ;
char *word ;	/* search pattern */
{
  long i, offset ;
  int flag=0 ;
  
  if( strlen(word)>0 )
  {
    last_s=0 ;
    strcpy(finds,word) ;
  }
  else
  {
    strcpy(word,finds) ;
  }
  
  if( (offset=kkystr((str+last_s),word))<0 )
    return(-1) ;

  offset+=last_s ;
  
  last_s=offset+1 ;
  
  i=offset ;
  while( *(str+i)!=10 && *(str+i)!=13 && i>0 )
    i-- ;

  if(i>0)
    i++ ;
      
  return(i) ;
}
    

/*--- To show the menu screen ---*/
int show(str)
char *str ;
{
  long i=0, j, cnt=0 ;
  long posi ;
  long n=0, cols=0 ;
  long ph ;
  char cr=13, lf=10 ;
  char *tab="        " ;
  char key ;
  char comm[100] ;
  int handle ;
  int tail=1 ;	/* check if tail page */
  char prompt_line[80];
 
  int l, blink=NORMAL, fc, fc1, bc, jmp, no ;  /* color function variables */
  char num[5];
  int colormap[16];				/* color transfer table */

  colormap[0]=BLACK;
  colormap[1]=BLUE;
  colormap[2]=GREEN;
  colormap[3]=CYAN;
  colormap[4]=RED;
  colormap[5]=MAGENTA;
  colormap[6]=BROWN;
  colormap[7]=LIGHTGRAY;
  colormap[8]=DARKGRAY;
  colormap[9]=LIGHTBLUE;
  colormap[10]=LIGHTGREEN;
  colormap[11]=LIGHTCYAN;
  colormap[12]=LIGHTRED;
  colormap[13]=LIGHTMAGENTA;
  colormap[14]=YELLOW;
  colormap[15]=WHITE;
  
  while(*(str+i)!=0)
  {
    if(*(str+i)==14)    /* CHR(14) will destroy screen font set */
    {                   /* CHR(15) can recover it               */
      *(str+i)=' ' ;
      continue ;
    }
    
    if( !strncmp((str+i), META_LEFT, 2) )
    {
      i+=2 ;
      l=0 ;     /* command length */
      jmp=0 ;   /* fc & bc switch */
      fc=-1;    /* if fc no change fc=-1 */ 
      fc1=-1;   /* precode for fc */
      bc=-1;    /* if bc no change bc=-1 */
           
      while( strncmp((str+i), META_RIGHT, 2) )
      {
        if(*(str+i)==0  || l>10)
          break ;

        if(tolower(*(str+i))=='b')
        {
          blink=BLINK ;         /* set blink */
          printf("\33[%dm",blink);
          fflush(stdout);
        }
    
        if(tolower(*(str+i))=='c')
        {
          clrscr() ;         /* clear screen */
        }

        if(tolower(*(str+i))=='p')
        {
          readkey() ;         /* Pause */
        }

        if(tolower(*(str+i))=='n')
        {
          blink=NORMAL ;             /* set normal color */
          printf("\33[%dm",blink);
          fflush(stdout);
        }

        if(tolower(*(str+i))==',')
        {
          jmp=1 ;
        }

        if( isdigit(*(str+i)) )
        {
          num[0]=*(str+i++) ;
          l++ ;
          if( isdigit(*(str+i)) )
          {
            num[1]=*(str+i++) ;
            l++ ;
            num[2]=0 ;
          }
          else
          {
            num[1]=0 ;
          }

          if( jmp==0 )
          {
            fc=atoi(num) ;
            jmp=1 ;
          }
          else
          {
            bc=atoi(num) ;
          }
          continue ;
        }
        i++ ;

      }/*end while(META_RIGHT)*/

      i+=2 ;	/*skip META_RIGHT*/
      
      if (fc!=-1) 
       {
        fc=colormap[fc];    /* color code transfer */ 
        fc1=fc / 128;	    /* precode generate */
        fc=fc % 128;
        if (fc1==0)
         {
          printf("\33[%dm",fc);
         }
        else 
         {
          printf("\33[%d;%dm",fc1,fc);
         }
        fflush(stdout);
       }

      if (bc!=-1)
       {
         bc=colormap[bc]+10;  /* bc code = fc code + 10 */ 
         printf("\33[%dm",bc);
         fflush(stdout);
       }

       continue;

    }/*end if(META_LEFT)*/


    if(*(str+i)==10)
    {
      write(1,&cr,1) ;
      n++ ;
      cols=0 ;
      write(1,(str+i),1) ;      /*--- print new line ---*/
      if(n%(SCR_ROWS-2)==0)
      {
        cnt=0 ;		/* count the line number under here */
        j=i+1 ;
        while( *(str+j)!=0 )
        {
          if(cnt==0)
            posi=j ;
          
          if( *(str+(j++))==10 )
            cnt++ ;
        }
        
        if( cnt>LINES )
          tail=0 ;     
        else
          tail=1 ;
          
        j=i+1 ;
        while( *(str+j)!=10 && *(str+j)!=0 )
        {
	  if( !strncmp((str+j), META_LEFT, 2) )
          {
            j+=2 ;
      	    l=0 ;     /* command length */
	    jmp=0 ;   /* fc & bc switch */
	    fc=-1;    /* if fc no change fc=-1 */ 
	    fc1=-1;   /* precode for fc */
	    bc=-1;    /* if bc no change bc=-1 */

	    while( strncmp((str+j), META_RIGHT, 2) )
      	    {
              if(*(str+j)==0  || l>10)
          	break ;

	      if(tolower(*(str+j))=='b')
	      {
		blink=BLINK ;         /* set blink */
		printf("\33[%dm",blink);
		fflush(stdout);
	      }

              if(tolower(*(str+j))=='c')
              {
                clrscr() ;         /* clear screen */
              }

              if(tolower(*(str+j))=='p')
              {
                readkey() ;         /* Pause */
              }

	      if(tolower(*(str+j))=='n')
	      {
		blink=NORMAL ;             /* set normal color */
		printf("\33[%dm",blink);
		fflush(stdout);
	      }

              if(tolower(*(str+j))==',')
              {
		jmp=1 ;
              }

	      if( isdigit(*(str+j)) )
              {
		num[0]=*(str+j++) ;
		l++ ;
		if( isdigit(*(str+j)) )
		{
		  num[1]=*(str+j++) ;
		  l++ ;
		  num[2]=0 ;
		}
		else
		{
		  num[1]=0 ;
		}

		if( jmp==0 )
		{
		  fc=atoi(num) ;
		  jmp=1 ;
		}
		else
		{
		  bc=atoi(num) ;
		}
		continue ;
	      }
              j++ ;

            }/*while(META_RIGHT)*/
      
            j+=2 ;  	/* skip META_RIGHT*/
      
	    if (fc!=-1) 
	    {
	      fc=colormap[fc];    /* color code transfer */ 
	      fc1=fc / 128;	    /* precode generate */
              fc=fc % 128;
              if (fc1==0)
	      {
		printf("\33[%dm",fc);
	      }
	      else 
              {
		printf("\33[%d;%dm",fc1,fc);
              }
              fflush(stdout);
            }

            if (bc!=-1)
            {
	      bc=colormap[bc]+10;  /* bc code = fc code + 10 */ 
              printf("\33[%dm",bc);
              fflush(stdout);
            }

            continue;

          }/*end if(META_LEFT)*/

    
          if(*(str+j)==9)     /* TAB */
          {
            if((cols%8)==0)
            {
              write(1,tab,1) ;
              cols++ ;
            }
            while(cols%8)
            {
              write(1,tab,1) ;
              cols++ ;
            }  
            j++ ;
            continue ;
          }
          
          write(1,(str+j),1) ;
          cols++ ;
          j++ ;
        }

        if( *(str+j)==10 )
        {
          write(1,(str+j),1) ;
          write(1,&cr,1) ;
          cols=0 ;
        }
        else
          return(0) ;	/* *(str+j)=0 */

	if( term_mode==0 )
	  sprintf(prompt_line, "%s, %s ", MORE, CAP_PROMPT);
	else
	  sprintf(prompt_line, "%s ", MORE);

	do
	{
          show(prompt_line) ;

          key=readkey() ;
          if(key==23 && term_mode==0)   /*--- capture post ---*/
          {
            printf("\r                                                                     \r") ;
            printf("%s",CAPTUREFILE) ;
            getstring(-1,-1,capfn,79-strlen(CAPTUREFILE),1) ;
            if((handle=open(capfn,O_CREAT|O_APPEND|O_WRONLY,S_IREAD|S_IWRITE))<0)
            {
              printf("file open error") ;
              key=readkey() ;
            }  
	    else
	    {
              clear_cr(str) ;
              write(handle,str,strlen(str)) ;
              write(handle,&lf,1) ;
              close(handle) ;
	    }
	    printf("\r                                                                     \r") ;
	    fflush(stdout) ;

	    continue;
          }

	  break;

	}while(TRUE);
        
        switch(key)
        {
          case 'q':
          case 'Q':
            write(1,&cr,1) ;
            show("                                                                     ") ;
            write(1,&cr,1) ;
            show("\n") ;
            return(FALSE) ;
          case 'b':
          case 'B':
            ph=0 ;
            for(j=i; j>=0; j--)
            {
              if( *(str+j)==10 )
                ph++ ;
                
              if( ph>(SCR_ROWS-2)*2 )
              {
                break ;
              }
            }
            
            cnt=0 ;
	    i=j ;
	    last_s=j ;		/* adjust last_search */
	    
            break ;
          case '/':	/* search */
            write(1,&cr,1) ;
            show("                                                                     ") ;
            write(1,&cr,1) ;
            show("/") ;
            comm[0]=0 ;
            getstring(-1,-1,comm,60,1) ;
            
            if( (l=search_word(str,comm))<0 )
            {
              show(" not found!!") ;
              readkey() ;
              ph=0 ;
              for(j=i; j>=0; j--)
              {
                if( *(str+j)==10 )
                  ph++ ;
                
                if( ph>(SCR_ROWS-2) )
                {
                  break ;
                }
              }
            
              cnt=0 ;
    	      i=j ;

            }
            else
            {
              i=l-1 ;
              cnt=0 ;
              clrscr() ;
            }
            break ;  
            
        }    
	
	if( !tail )
	  clrscr() ;
	else
  	  erase_line() ;
  
        if( (cnt>0) && (cnt<SCR_ROWS-1) )
        {
          i=posi ;
        }
      }
      
      i++ ;  
        
      continue ;
    }  
 
    if(*(str+i)==9)     /* TAB */
    {
      if((cols%8)==0)
      {
        write(1,tab,1) ;
        cols++ ;
      }
      while(cols%8)
      {
        write(1,tab,1) ;
        cols++ ;
      }  
    }  
    else
    {  
      write(1,(str+i),1) ;
      cols++ ;
    }

    i++ ;

  }/*end while( *(str+i)!=0)*/
}

/*--- To erase cr ---*/
int clear_cr(buf)
char *buf ;
{
  int i ;
  
  i=0 ;
  while(*(buf+i)!=0)
  {
    if((*(buf+i)==13) && (*(buf+i+1)==10))
      *(buf+i)=' ' ;
    i++ ;
  }
}

/*--- To erase cr ---*/
int clear_esc(buf)
char *buf ;
{
  int i ;
  
  i=0 ;
  while(*(buf+i)!=0)
  {
    if( *(buf+i)==27 )
      *(buf+i)=' ' ;
    i++ ;
  }
}

      
/*--- To get a key input ---*/
int readkey()
{
  return(getch()) ;
}


/*--- To location (x,y) ---*/
int gotoxy(x,y) 
int x ;
int y ;
{
  printf("%c[%d;%dH",27,y,x) ;
  fflush(stdout) ;
}

/*--- Erase one line ---*/
int erase_line()
{
  printf("\r%79s\r"," ") ;
  fflush(stdout) ;
}
  
/*--- Clear screen ---*/
int clrscr()
{
  clear() ;
  refresh() ;
}
