
/*connectTCP - TCP connection */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <varargs.h>

#include <netinet/in.h>

#include <netdb.h>

#ifndef INADDR_NONE
#define INADDR_NONE	0xffffffff
#endif

extern int	errno;
#ifdef NETBSD
#else
#ifdef FREEBSD
#else
extern char	*sys_errlist[];
#endif
#endif

#ifdef SYSV
#define	bzero(a, b)	memset(a, 0, b)	/*SysV do not support bzero*/
#define bcopy(a, b, c)	memcpy(b ,a, c)	/*SysV do not support bcopy*/
#endif

static char rcsid[]="$Id: tcp.c,v 1.2 1995/11/11 11:44:08 pbbs Exp pbbs $" ;

/*u_short htons();*/
u_long	inet_addr();

/**************************************************************/
int
connectTCP( host, service)
char *host;
int service;
{
	struct hostent	*phe;
	struct servent	*pse;
	struct sockaddr_in	sin;
	int	s;

	bzero((char *)&sin, sizeof(sin));
	sin.sin_family=AF_INET;

	/*map port number*/
	if( (sin.sin_port=htons((u_short)service)) == 0 )
		errexit("can't get %s service entry\n\r", service);

	/*get IP address*/
	if( phe = gethostbyname(host) )
		bcopy(phe->h_addr, (char *)&sin.sin_addr, phe->h_length);
	else if( (sin.sin_addr.s_addr = inet_addr(host)) == INADDR_NONE )
		errexit("can't get %s host entry\n\r", host);

	/*allocate socket*/
	s = socket(PF_INET, SOCK_STREAM, 0);
	if(s<0)
		errexit("can't create socket: %s\n\r", sys_errlist[errno]);

	/*connect the socket*/
	if(connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0)
		errexit("PBBS service may not be available on %s.%d: %s\n\r", host, service,
			sys_errlist[errno]);

	return(s);
}



errexit(format, va_alist)
char	*format;
va_dcl
{
	char err_buf[128];

	va_list args;
	va_start(args);
	vsprintf(err_buf, format, args);
	va_end(args);

	printf("%s", err_buf);
	exit(1);
}
