#include <curses.h>
#include "msg.h"

#ifndef LINUX
#include <sgtty.h>
#endif

#ifdef LINUX
#include <bsd/sgtty.h>
#endif

#ifdef NETBSD
#include <termios.h>
#else
#ifdef FREEBSD
#include <termios.h>
#else
#include <termio.h>
#endif
#endif

#ifdef IRIX
#include <sys/ttold.h>
#endif

#include "msg.h"
#include "pbbs.h"

static char rcsid[]="$Id: talk.c,v 1.2 1995/11/11 11:44:08 pbbs Exp pbbs $" ;

int chat_room(fd,buf)
int fd ;
char *buf ;
{
  fd_set rset, allset ;
  struct timeval timeout ;

#ifdef NETBSD
  struct termios save,term ;
#else 
#ifdef FREEBSD
  struct termios save,term ;
#else
  struct termio save,term ;
#endif
#endif

  int maxfd ;
  
  char tmp[100] ;
  char prot ;
  long l ;
  int i,
      len,
      quit=0,
      cy=1,       /* chat y-axis */
      sx=2 ;

  unsigned int  bs ;
  unsigned char chr ;
  struct sgttyb csgttyb ;
  
  ioctl(1, TIOCGETP, &csgttyb);		/* get backspace key */
  bs=csgttyb.sg_erase;
 
#ifdef NETBSD
  ioctl(0,TIOCGETA,&term) ;		/* set key mode to allow kbhit */
#else
#ifdef FREEBSD
  ioctl(0,TIOCGETA,&term) ;		/* set key mode to allow kbhit */
#else
  ioctl(0,TCGETA,&term) ;		/* set key mode to allow kbhit */
#endif
#endif

  save=term;
  term.c_lflag&=~ICANON;
  term.c_lflag&=~ECHO;

  term.c_cc[VMIN]=0;
  term.c_cc[VTIME]=0;

#ifdef NETBSD
  ioctl(0,TIOCSETA,&term) ;		/* set key mode to allow kbhit */
#else
#ifdef FREEBSD
  ioctl(0,TIOCSETA,&term);
#else
  ioctl(0,TCSETA,&term);
#endif
#endif

  /* init screen */
  clrscr() ;
  for(i=1; i<=SCR_ROWS-3; i++)
    show("\n") ;
  memset(tmp,'=',80) ;
  tmp[80]=0 ;
  len=strlen(buf) ;
  if(len<38)
  {
    write(1,tmp,38) ;
    write(1,buf,len) ;
    write(1,tmp,COLS-len-40) ;
  }
  else
  {
    write(1,tmp,COLS-len-2) ;
    write(1,buf,len) ;
  }
  show("\n\n>") ;
  
  /*--- init select I/O ---*/
  maxfd=(fd>fileno(stdin)) ? (fd+1):(fileno(stdin)+1) ;
  FD_ZERO(&allset) ;
  FD_SET(fd,&allset) ;
  FD_SET(fileno(stdin),&allset) ;
  timeout.tv_sec=10 ;
  timeout.tv_usec=0 ;

  while(TRUE)      /* into chat room & start talking */
  {
    rset=allset ;
    if( select(maxfd,&rset,NULL,NULL,&timeout)<0 )
      show("(talk.c) select error!!\r\n") ;
    
    if( FD_ISSET(fd,&rset) )
    {
      if( read_mpf(fd,buf,&l,&prot,FALSE)==1 )
      {
        buf[l]=0 ;
        if( prot==ENDTALK )
        {
          break ;
	
	  /*break while loop*/
        }

        if( prot==TALK )
        {
          gotoxy(1,cy++) ;
          erase_line() ;
          show(buf) ;
          if(cy>SCR_ROWS-3)
          {
            cy=1 ;
          }
          gotoxy(1,cy) ;
          erase_line() ;
          show("---->") ;

          gotoxy(sx,SCR_ROWS) ;
        }

        if( prot==REJECT )
        {
          show("\n") ;
          hang_up(buf,fd) ;
        }
      }
    }

    while( read(0,&chr,1)>0 )
    { 
      if( quit )
	continue;

      if(chr==bs)
        chr=8 ;

      switch(chr)
      {
        case 5:		/*Ctrl-E to exit*/
          quit=1 ;
          send_mpf(fd,buf,1,STOPTALK) ;
          break ;
        case 8:
          if(sx>2)
          {
            printf("%c%c%c",8,32,8) ;
            fflush(stdout) ;
            tmp[sx--]=0 ;
          }
          break ;
        case 10:
        case 13:
          tmp[sx]=0 ;
          if(sx>2)
          {
            send_mpf(fd,&tmp[2],sx-2,TALK) ;
            erase_line() ;
            show(">") ;
            memset(tmp,0,10) ;
            sx=2 ;
          }
          break ;
        default:
          if( sx<COLS-18 && chr>=32 )
          {
            tmp[sx++]=chr ;
            printf("%c", chr); 
	    fflush(stdout);
            
          }
      }/*end switch char*/
    }

  } /* end while */

#ifdef NETBSD
  ioctl(0,TIOCSETA,&save) ;
#else
#ifdef FREEBSD
  ioctl(0,TIOCSETA,&save) ;
#else
  ioctl(0,TCSETA,&save) ;
#endif
#endif
}
