/****************************************
    Show the post
    write by Aquarisu Kuo
    Apr 20, 1994
    remodified by Samson Chen Apr 2, 1995
*****************************************/

#include <curses.h>
#include <ctype.h>
#include "msg.h"


#ifndef LINUX
#include <sgtty.h>
#endif

#ifdef LINUX
#include <bsd/sgtty.h>
#endif


#include "pbbs.h"
#include "msg.h"

#define COL	78

long kkystr() ;

static char rcsid[]="$Id: showmail.c,v 1.1 1995/11/11 08:47:27 pbbs Exp pbbs $" ;

extern WINDOW *stdscr,*curscr ;
extern char capfn[80] ;
extern int intrread_point;

static int PgUp=FALSE ;
static int last_page_i ;

static char finds[100] ;
static long last_s ;

/*for multi-layer INTRSEL point stack*/
extern int isel_point_stk[256];  /*ASC 49 (1) --- ASC 255 : 207 layers max*/



/**********************************
   check the input key
   for the function pager()
*/
int in_range(key)
char *key ;
{
  int ret, k ;

  switch(*key)
  {
    case 'q':   /* quit */
    case 'r':   /* reply */
    case 'm':   /* email reply */
    case 's':   /* search pattern */
    case 'f':   /* file post */
    case 'p':   /* pre-post */
    case 'n':   /* next post */
    case 'u':   /* up page */
    case 'd':   /* down page */
    case ' ':   /* down page */
    case 'k':   /* kill post */
    case 'e':   /* enter a new post */
    case 'c':   /* cream */
    case '+':   /* relation up */
    case '-':   /* relation next */
    case '/':   /* search */
    case 13 :	/* next post */
    case 10 :
	ret=1 ;
	break ;
    case 27:	/*Arrow Keys*/
	if((k=readkey())=='[' || k=='O'  || k=='0' )
	{
	  k=readkey() ;
	  if( (k=='C') || (k=='D') || (k=='A') || (k=='B') )
	  {
	    *key=k ;
	    ret=1 ;
	  }
	  else
	    ret=0 ;
	}
	else
	  ret=0 ;
	break ;
    default:
      ret=0 ;
  }

  return(ret) ;

}
/*end of in_range*/



/*
  get rid of ANSI color code in output *(str+i)
  by Samson Chen
*/
strip_ANSI_write(iofd, str, i, n)
int iofd;	/*output fd*/
char *str;	/*output buffer*/
long *i;	/*output offset*/
int n;		/*output number*/
{
  int acnt, ret=0;

  if( !strncmp((str+(*i)), "\33[", 2) )  /*ANSI head*/
  {
    ret=1;
    for(acnt=0; acnt<16; acnt++)
    {
      if( *(str+(*i)+2+acnt)==0 )
	break;

      if( *(str+(*i)+2+acnt)=='m' )      /*color command*/
      {
	ret=2+acnt;
	break;
      }

      if( *(str+(*i)+2+acnt)==';' )
	continue;

      if( isdigit( *(str+(*i)+2+acnt) ) )
	continue;

      /*another ANSI command??? strip only ESC*/
	break;
    }/*end for*/
  }/*end if*/
  else if( *(str+*i)=='\33' )      /*Only ESC for what?*/
  {
    (*i)--;
    ret=1;
  }

  if( ret>0 )
    (*i)+=ret;
  else
    write(iofd, (str+(*i)), n);

  return(ret);
}
/*end of strip_ANSI*/



/*--- To show the text by pages ---*/
/*--- return the last pressed key ---*/
int pager(head,body)
/*
  return:
	  -3: pre-post
	  -2: next post
	  -1: key response
	   0: quit
	  >0: post number
*/
char *head ;
char *body ;
{
  long i=0, j, l, head_p=0,	/*head_p mark the first char of each page*/
       n=0,
       cols=0,
       here=0 ; 	 /*--- current page's head line ---*/

  int page_lines;

  int handle ;

  int apos;

  char cr=13,
       lf=10,
       *tab="        ",
       key ;

  char comm[100] ;
  char num[100] ;

  int ret;

  clrscr() ;
  show("{#3#}");
  show(head) ;
  show("{#n#}");

  page_lines=SCR_ROWS-8;

  while(1)
  {
    if((*(body+i)<32) && (*(body+i)>0) && (*(body+i)!=9) && (*(body+i)!=10) && (*(body+i)!=27) )
    {
      *(body+i)=' ' ;
    }

    if(*(body+i)==10)
    {
      /*--- get '\n' ---*/
      write(1,&cr,1) ;	/*--- append carried return ---*/
      n++ ;
      cols=0 ;
      if(n % (page_lines-1)==0)        /*--- count the lines if full the screen ---*/
      {
	strip_ANSI_write(1,body,&i,1) ;

	j=i+1 ;
	while(*(body+j)!=0 && *(body+j)!=10 )
	{
	  if( *(body+j)==9 )
	  {
	    if(cols%8==0)
	    {
	      write(1,tab,1) ;
	      cols++ ;
	    }
	    while(cols%8)
	    {
	      write(1,tab,1) ;
	      cols++ ;
	      if(cols>COL)
	      {
		while((*(body+j)!=10) && (*(body+j)!=0))
		  j++ ;
		cols=0 ;
		break ;
	      }
	    }
	    if(cols!=0)
	      j++ ;

	    continue ;
	  }	/* end check tab */

	  if(cols<=COL)
	    strip_ANSI_write(1,body,&j,1) ;

	  cols++ ;
	  j++ ;
	}

	if( *(body+j)==10 )
	{
	  write(1,(body+j),1) ;
	  cols=0 ;
	}

	write(1,&cr,1) ;


	do
	{
	  n=0;
	  ret=get_read_answer(&key);
	  if( ret>0 )
		return(ret);		/*user input number*/

	  if(key==23 && term_mode==0)	/*--- capture post ---*/
	  {
	    show(CAPTUREFILE) ;
	    getstring(-1,-1,capfn,79-strlen(CAPTUREFILE),1) ;
	    if((handle=open(capfn,O_CREAT|O_APPEND|O_WRONLY,S_IREAD|S_IWRITE))<0)
	    {
	      printf("\r\nOpen capture file error!\r\n") ;
	      readkey();
	    }
	    else
	    {
	      clear_cr(head) ;
	      clear_cr(body) ;
	      write(handle,head,strlen(head)) ;
	      write(handle,body,strlen(body)) ;
	      write(handle,"\n\n",2) ;
	      close(handle) ;
	    }

	    erase_line() ;
	    continue ;
	  }

	  break;
	}
	while(TRUE) ;


	/********/
	/* quit */
	/********/
	if( key=='q' || key=='D' )
	{		/* <- */
	  return(0) ;
	}


	/*************/
	/* next post */
	/*************/
	if( (key==10) || (key==13) || (key=='n') || (key=='C') )
	{					     /* -> */
	  return(-2) ;
	}


	/*****************/
	/* previous post */
	/*****************/
	if( key=='p' )
	{
	  return(-3) ;
	}


	/******************/
	/* in-post search */
	/******************/
	if(key=='/')
	{
	  erase_line() ;
	  show("/") ;
	  comm[0]=0 ;
	  getstring(-1,-1,comm,60,1) ;

	  if( (l=search_word(body,comm))<0 )
	  {
	    show(SCANOFIND) ;
	    readkey() ;
	    i=head_p-1;
	  }
	  else
	  {
	    i=l-1 ;
	  }

	  i++ ;
	  n=0;
	  head_p=i;
	  clrscr() ;
	  show("{#3#}");
	  show(head) ;
	  show("{#n#}");
	  continue ;

	}


	/***************/
	/*previous page*/
	/***************/
	if(key=='u' || key=='A')
	{		/* ^ */
	  clrscr() ;
	  show("{#3#}");
	  show(head) ;
	  show("{#n#}");

	  here=0 ;
	  for(j=head_p; j>0; j--)
	  {
	    if( *(body+j)==10 )
	      here++ ;

	    if( here >= page_lines )
	    {
	      break ;
	    }
	  }
	  i=(j>0) ? j: -1 ;
	  i++ ;
	  last_s=i ;	      /* adjust last_search */
	  head_p=i;
	  continue ;
	}


	/*************/
	/* next page */
	/*************/
	if( (key==' ') || (key=='d') || (key=='B') )
	{				 /* v */
	  clrscr() ;
	  show("{#3#}");
	  show(head) ;
	  show("{#n#}");

	  i++ ;
	  head_p=i;
	  continue ;
	}

	/**********************/
	/* Other response key */
	/**********************/
	body[0]=key ;
	return(-1) ;

      }
      else
      {
	strip_ANSI_write(1,body,&i,1) ;
	i++ ;
	continue ;
      }
    }

    if(*(body+i)==9)	/* TAB */
    {
      if(cols%8==0)
      {
	write(1,tab,1) ;
	cols++ ;
      }
      while(cols%8)
      {
	write(1,tab,1) ;
	cols++ ;
	if(cols>COL)
	{
	  while((*(body+i)!=10) && (*(body+i)!=0))
	    i++ ;
	  cols=0 ;
	  break ;
	}
      }
      if(cols!=0)
	i++ ;

      continue ;
    }


    if(*(body+i)==0)
    {
	/**************************/
	/*** last page run here ***/
	/**************************/

	do
	{
	  n=0;
	  ret=get_read_answer(&key);
	  if( ret>0 )
		return(ret);		/*user input number*/

	  if(key==23 && term_mode==0)	/*--- capture post ---*/
	  {
	    show(CAPTUREFILE) ;
	    getstring(-1,-1,capfn,79-strlen(CAPTUREFILE),1) ;
	    if((handle=open(capfn,O_CREAT|O_APPEND|O_WRONLY,S_IREAD|S_IWRITE))<0)
	    {
	      printf("\r\nOpen capture file error!\r\n") ;
	      readkey();
	    }
	    else
	    {
	      clear_cr(head) ;
	      clear_cr(body) ;
	      write(handle,head,strlen(head)) ;
	      write(handle,body,strlen(body)) ;
	      write(handle,"\n\n",2) ;
	      close(handle) ;
	    }

	    erase_line() ;
	    continue ;
	  }

	  break;
	}while(TRUE) ;


	/********/
	/* quit */
	/********/
	if( key=='q' || key=='D' )
	{		/* <- */
	  return(0) ;
	}


	/*************/
	/* next post */
	/*************/
	if( (key==10) || (key==13) || (key=='n') || (key=='C') )
	{					     /* -> */
	  return(-2) ;
	}


	/*************************************/
	/* next page (no more so next post)  */
	/*************************************/
	if( (key==' ') || (key=='d') || (key=='B') )
	{				 /* v */
	  return(-2) ;
	}


	/*****************/
	/* previous post */
	/*****************/
	if( key=='p' )
	{
	  return(-3) ;
	}


	/******************/
	/* in-post search */
	/******************/
	if(key=='/')
	{
	  erase_line() ;
	  show("/") ;
	  comm[0]=0 ;
	  getstring(-1,-1,comm,60,1) ;

	  if( (l=search_word(body,comm))<0 )
	  {
	    show(SCANOFIND) ;
	    readkey() ;
	    i=head_p-1;
	  }
	  else
	  {
	    i=l-1 ;
	  }

	  i++ ;
	  n=0;
	  head_p=i;
	  clrscr() ;
	  show("{#3#}");
	  show(head) ;
	  show("{#n#}");
	  continue ;

	}


	/***************/
	/*previous page*/
	/***************/
	if(key=='u' || key=='A')
	{		/* ^ */
	  clrscr() ;
	  show("{#3#}");
	  show(head) ;
	  show("{#n#}");

	  here=0 ;
	  for(j=head_p; j>0; j--)
	  {
	    if( *(body+j)==10 )
	      here++ ;

	    if( here >= page_lines )
	    {
	      break ;
	    }
	  }
	  i=(j>0) ? j: -1 ;
	  i++ ;
	  last_s=i ;	      /* adjust last_search */
	  head_p=i;
	  continue ;
	}


	/**********************/
	/* Other response key */
	/**********************/
	body[0]=key ;
	return(-1) ;

    }
    else
    {
      strip_ANSI_write(1,body,&i,1) ;
      cols++ ;
    }
    i++ ;
    if(cols>78)
    {
      while((*(body+i)!=10) && (*(body+i)!=0))
	i++ ;
    }
  }
}
/*end of pager*/



/*
	get_read_answer --- get user input in read prompt
	for pager() function
*/
get_read_answer(ukey)
	char *ukey;
/*
	return: 0:	user_key
		>0	number
*/
{
	char num[80];
	int ret;
	int x, y, a, b;

	/***************/
	/* show prompt */
	/***************/
	show("{#2#}");

	if( term_mode==0 )
	{
	  gotoxy(51, SCR_ROWS-2);
	  show(CAP_PROMPT);
	}
	gotoxy(66, SCR_ROWS-2);
	show(SEARCH_PMT);
	gotoxy(1, SCR_ROWS-1);
	show(POST_MORE1);
	gotoxy(1, SCR_ROWS);
	show(POST_MORE2);

	show("{#n#}");

	ret=0;

	do
	{
	  *ukey=readkey();

	  if( *ukey==27 )	/*ANSI Keys*/
	  {
	    *ukey=readkey();
	    if( (*ukey!='[') && (*ukey!='O') && (*ukey!='0') )
	      continue;

	    *ukey=readkey();

	    if( *ukey=='A' || *ukey=='B' || *ukey=='C' || *ukey=='D' )
	      break;
	    else
	      continue;
	  }

	   /* save capture file */
	  if(*ukey==23 && term_mode==0)
	    break;

	  if(isdigit(*ukey))
	  {
	    num[0]=*ukey ;
	    num[1]=0 ;

	    if(getstring(-1,-1,num,5,3)<=0)
	      continue;
	    else
	    {
	      ret=atoi(num);
	      break;
	    }
	  }

	  *ukey=tolower((char)*ukey) ;

	  if( in_range((char*)ukey) )
	    break;
	}
	while(TRUE);

	/****************/
	/* erase prompt */
	/****************/
	gotoxy(1, SCR_ROWS-2);
	erase_line();
	gotoxy(1, SCR_ROWS-1);
	erase_line();
	gotoxy(1, SCR_ROWS);
	erase_line();

	gotoxy(1, SCR_ROWS-1);

	return(ret);
}
/*end of get_read_answer*/




/*
    List each post num, from, subject
    input format: "<msg_no>\crlf<description>\crlf<item_name>\crlf{next_one}"
*/
int postlist(buf, imode)
char *buf;
int imode;	/* mode 1: INTRREAD, mode 2: INTRSEL*/
{
  char *pbuf;
  int pl[80] ;
  char relate_mark=FALSE;
  char mark_len, list_len;
  int n, i, j ;
  int cols ;
  char num[8] ;
  int ch, key,empty=0 ;
  char select_msg[100];
  char null_pad[80];
  int ukey;
  int ret_no;
  int new_i;
  int x, y, a, b;
  int intrsel_point=0;
  unsigned char isel_point=0;	/*default layer*/

  pbuf=buf;

  /******************************************************************/
  /* parsing INTRSEL layer number				    */
  /*----------------------------------------------------------------*/
  /* layer number encapsulated with other intrsel text like	    */
  /* <layer no.>![intrsel text] for example,			    */
  /* 1![intrsel text]						    */
  /* <layer no.> is an unsigned char withc begins from 1 (ASC 49)   */
  /* only ONE char is used, that is when layer > 10, for example 10 */
  /* the char for <layer no.> is ':' (ASC 58)                       */
  /* by the way, the ASC of the seperator '!' is 33                 */
  /******************************************************************/
  if( imode==2 && strlen(buf)>3 )
  {
    if( pbuf[1]=='!' )
    {
	isel_point=pbuf[0]-'1';
	pbuf=pbuf+2;
    }

    if( isel_point_stk[isel_point]>0 )
    {
	intrsel_point=isel_point_stk[isel_point];
	n=isel_point;
	while( isel_point_stk[n]!=0 && n<255 )
		isel_point_stk[n++]=0;
    }
  }


  if(pbuf[0]==0)
    empty=TRUE ;

  n=parse_msg(pl,pbuf)-1 ;

  clear() ;
  refresh() ;

  /*********************/
  /*assemble title line*/
  /*********************/
  i=strlen(SELECTMSG);
  j=(79-i)/2;
  memset(null_pad, ' ', j);
  null_pad[j]=0;
  strcpy(select_msg, "{#15,5#}");
  strcat(select_msg, null_pad);
  strcat(select_msg, SELECTMSG);
  strcat(select_msg, null_pad);
  strcat(select_msg, "{#n#}");
  strcat(select_msg, "\r\n");
  show(select_msg);

  /******************/
  /*put select items*/
  /******************/
  mark_len=strlen(iread_mark);
  for(i=0; i<=n; i++)
  {
    if( imode==1 && mark_len!=0 )
    {
      if( !strncmp( (pbuf+i*100)+26, "Re: ", 4) )
      {
	list_len=strlen((pbuf+i*100)+26+4);
	if( !strncmp( (pbuf+i*100)+26+4, iread_mark, (mark_len<list_len)?mark_len:list_len) )
	  relate_mark=TRUE;
      }
      else
      {
	list_len=strlen((pbuf+i*100)+26);
	if( !strncmp( (pbuf+i*100)+26, iread_mark, (mark_len<list_len)?mark_len:list_len) )
	  relate_mark=TRUE;
      }
    }

    if( relate_mark )
    {
      show("{#10#}");
      printf("   %-.75s\r\n",(pbuf+i*100)) ;
      show("{#n#}");
      relate_mark=FALSE;
    }
    else
      printf("   %-.75s\r\n",(pbuf+i*100)) ;
  }
  fflush(stdout) ;

  show("{#2#}");

  if( imode==1 )	/*INTRREAD*/
  {
    gotoxy(1, SCR_ROWS-1);
    show(IR_PROMPT1);
    gotoxy(1, SCR_ROWS);
    show(IR_PROMPT2) ;
    cols=strlen(IR_PROMPT2)+1 ;
  }
  else			/*INTRSEL*/
  {
    gotoxy(1, SCR_ROWS-1);
    show(SEL_PROMPT1);
    gotoxy(1, SCR_ROWS);
    show(SEL_PROMPT2) ;
    cols=strlen(SEL_PROMPT2)+1 ;
  }

  show("{#n#}");

  i=0;
  if(n<0)
	empty=TRUE ;
  else
  {
	if( PgUp )	/*find next i followed the previous page*/
	{
	  i=n;

	  while(i>=0)
	  {
	    if( pl[i]<=last_page_i )
		break;
	    i--;
	  }

	  if(i<0)
		i=n;

	  PgUp=FALSE;	/*reset PgUp*/

	}/*end if(PgUp)*/
	else
	{
	  /*intrread/intrsel_point checking*/

	  if( imode==1 && intrread_point>0 )
	  {
	    /*note:
	      intrread_point will be setup additionally in function parse_head()
	    */
	    i=n;
	    while(i>0)
	    {
		if( pl[i]==intrread_point )
			break;
		i--;
	    }

	    intrread_point=0;	/*reset var*/
	  }
	  else if( imode==2 && intrsel_point>0 )
	  {
	    i=n;
	    while(i>0)
	    {
		if( pl[i]==intrsel_point )
			break;
		i--;
	    }

	    intrsel_point=0;	/*reset var*/
	  }

	}/*end if*/

  }/*end if*/


  do
  {
    /*******************/
    /* draw arrow mark */
    /*******************/
    if(!empty)
    {
      gotoxy(1,i+2) ;
      printf(" ");
      show("->") ;
      gotoxy(cols,SCR_ROWS) ;
    }

    do
    {
      ukey=readkey() ;

      if( ukey==27 )	/*ANSI Keys*/
      {
	if((ukey=readkey())=='[' || ukey=='O'  || ukey=='0' )
	{
	  ukey=readkey() ;
	  switch(ukey)
	  {
	  case 'A':     /* ^ */
		ukey='p';
		break;

	  case 'B':     /* v */
		ukey='n';
		break;

	  case 'C':     /* -> */
		ukey=13;
		break;

	  case 'D':     /* <- */
		ukey='q';
		break;

	  default:
	    continue;

	  }/*end switch*/

	  break;	/* get user key */

	}
	else
	  continue;

      }/*end if(ukey==27)*/

      if(isdigit(ukey))
      {
	  num[0]=ukey ;
	  num[1]=0 ;

	  if(getstring(-1,-1,num,5,3)<=0)
		continue;
	  else
	  {
		ukey=0;
		ret_no=atoi(num);
		break;
	  }
      }

      ukey=tolower((char)ukey);

      if( imode==1 )	      /*INTRREAD*/
      {
	  if( intrread_valid_key(ukey) )
		break;
      }
      else		      /*INTRSEL*/
      {
	  if( intrsel_valid_key(ukey) )
		break;
      }

    } while(TRUE);

    /********************/
    /* erase arrow mark */
    /********************/
    if(!empty)
    {
      gotoxy(1,i+2) ;
      printf("   ") ;
      gotoxy(cols,SCR_ROWS) ;
    }

    /*********************/
    /* user press number */
    /*********************/
    if( ukey==0 && ret_no>0 )
    {
	/*keep point*/
	if( imode==1 )		/*intrread*/
		intrread_point=ret_no;
	else if( imode==2 )	/*intrsel*/
		isel_point_stk[isel_point]=ret_no;

	break;
    }

    /********/
    /* quit */
    /********/
    if(ukey=='q')
    {
      if( imode==1 )
	iread_mark[0]=0;
      break;
    }

    /*********/
    /* enter */
    /*********/
    if( (ukey==13) || (ukey==10) )
    {
      ret_no=pl[i];
      ukey=0;

      /*keep point*/
      if( imode==1 )		/*intrread*/
	intrread_point=ret_no;
      else if( imode==2 )	/*intrsel*/
	isel_point_stk[isel_point]=ret_no;

      break;
    }

    /*************/
    /* page down */
    /*************/
    if(ukey==' ' || ukey=='d')
    {
      ukey='d';
      break;
    }

    /***********/
    /* page up */
    /***********/
    if(ukey=='u')
    {
      PgUp=TRUE ;
      last_page_i=pl[0]-1;
      break;
    }

    /*****************/
    /* previous item */
    /*****************/
    if(ukey=='p')
    {
      i-- ;
      if(i<0)
      {
	ukey='u';
	PgUp=TRUE ;
	last_page_i=pl[0]-1;
	break;
      }
      else
	continue;
    }

    /*************/
    /* next item */
    /*************/
    if(ukey=='n')
    {
      i++ ;
      if(i>n)
      {
	ukey='d';
	break;
      }
      else
	continue;
    }

    /***************************************/
    /* enter post or file post in INTRREAD */
    /***************************************/
    if( imode==1 && (ukey=='e' || ukey=='f' || ukey=='s' || ukey=='c') )
    {
	break;
    }

    /*********************/
    /* select in INTRSEL */
    /*********************/
    if( imode!=1 && (ukey=='s') )
    {
	break;
    }

  }
  while(TRUE) ;

  /****************/
  /* erase prompt */
  /****************/
  gotoxy(1, SCR_ROWS-1);
  erase_line();
  gotoxy(1, SCR_ROWS);
  erase_line();

  gotoxy(1, SCR_ROWS-1);

  if( ukey==0 )
	return(ret_no);
  else
  {
	buf[0]=ukey;
	return(0);
  }

}
/*end of postlist*/



/*
	intrread_valid_key --- check if key valid in intrread
*/
intrread_valid_key(key)
	int key;
/*
	RETURN: TRUE: OK
		FALSE: not allowed key
*/
{
	int ret;

	switch(key)
	{
		case 10 :
		case 13 :	/*enter*/
		case ' ':       /*next page*/
		case 'd':       /*next page*/
		case 'e':       /*enter mail*/
		case 'f':       /*file post*/
		case 'n':       /*next item*/
		case 'p':       /*previous item*/
		case 's':       /*search*/
		case 'c':       /*cream*/
		case 'q':       /*quit*/
		case 'u':       /*previous page*/
			ret=TRUE;
			break;

		default:
			ret=FALSE;
			break;
	}

	return(ret);
}
/*end of intrread_valid_key*/



/*
	intrsel_valid_key --- check if key valid in intrsel
*/
intrsel_valid_key(key)
	int key;
/*
	RETURN: TRUE: OK
		FALSE: not allowed key
*/
{
	int ret;

	switch(key)
	{
		case 10 :
		case 13 :	/*enter*/
		case ' ':       /*next page*/
		case 'd':       /*next page*/
		case 'n':       /*next item*/
		case 'p':       /*previous item*/
		case 'q':       /*quit*/
		case 's':       /*select*/
		case 'u':       /*previous page*/
			ret=TRUE;
			break;

		default:
			ret=FALSE;
			break;
	}

	return(ret);
}
/*end of intrsel_valid_key*/
