/**************************************************************************
 * psocket.c --- general network subroutie				  *
 *		 by Samson Chen, Nov 28, 1993				  *
 **************************************************************************/

#include "pbbs.h"

static char rcsid[]="$Id: psocket.c,v 1.1 1995/11/11 08:47:27 pbbs Exp pbbs $";

/*****************************
	local structure define
*/
struct	mpf_head_s {
		char	prot;
		char	length[8];
	} mpf_head;

/*****************************
	local vars define
*/
char show_readmpf_status;
char status_bar[5]="|/-\\";
char bar_cnt=0;
char bar_display[10];

/****************************************
	sending via Message Packet Format
*/
send_mpf(fd, buffer, buf_len, protocol)
	int fd;		/*socket file descriptor*/
	char *buffer;	/*transmit data buffer*/
	unsigned long buf_len;	/*buffer length*/
	char protocol;	/*mpf protocol code*/
/*
	return: 0 = ok
		-1 = error occurred	(standard)
*/
{
	char	iac_buff=IAC;
	int	i ;
	int	ret;

	mpf_head.prot=protocol;
	sprintf(mpf_head.length, "%ld", buf_len);

	ret=write(fd, &iac_buff, 1);			/*send IAC*/
		if( ret<0 ) abnormal_disconnect(fd);
	ret=write(fd, (char*) &(mpf_head.prot), 1 );	/*send protocol code*/
		if( ret<0 ) abnormal_disconnect(fd);
	ret=write(fd, (char*) mpf_head.length, 8 );	/*send packet length*/
		if( ret<0 ) abnormal_disconnect(fd);

	if( buf_len>0 )
	{
		ret=write(fd, buffer, buf_len);	/*send buffer*/
		if( ret<0 ) abnormal_disconnect(fd);
	}

	return(0);
}
/*end of send_mpf*/


/**********************************
	read fix length from stream
*/
fix_read(fd, fix_len, buffer)
	int fd;		/*socket file descriptor*/
	unsigned long fix_len;	/*packet length*/
	char *buffer;	/*stored buffer*/
/*
	return: standard
*/
{
	char *pointer=buffer;
	unsigned long pcount=0;
	unsigned long n;

	while( pcount < fix_len )
	{
		n = read(fd, pointer, (fix_len-pcount) );
			if( n==0 ) abnormal_disconnect(fd);
		pcount += n;

		if(pcount<MAX_BUF-1024)
		  pointer = buffer + pcount;

		if( show_readmpf_status )
		{
		  sprintf(bar_display, "%c%c", *(status_bar+bar_cnt), 8);
		  bar_cnt++;
		  bar_cnt &=0x3;
		  show(bar_display);
		}
	}

	if( show_readmpf_status )
	{
	  sprintf(bar_display, " %c", 8);
	  show(bar_display);
	}

	return(0);
}
/*end of fix_read*/


/*************************************
	read via Message Packet Format
*/
read_mpf(fd, buffer, buf_len, protocol, nowait)
	int fd;		/*socket file descriptor*/
	char *buffer;	/*stored buffer*/
	unsigned long *buf_len;	/*length of stored buffer*/
	char *protocol;	/*fetched protocol code*/
	int nowait;	/*block read_mpf or not*/
/*
	return: -1 = error occurred
		-2 = garbage code received (in nowait mode)
		 0 = no data-in (in nowait mode)
		 1 = OK
*/
{
	char iac_buff;

	fd_set	rset;
	struct timeval	timeout;
	int maxfd, n;
	int i;

	if( nowait )	/*nowait will not block function*/
	{
		/*set mutiplex I/O check bit*/
		maxfd=fd + 1;
		FD_ZERO(&rset);
		FD_SET(fd, &rset);
		timeout.tv_sec=0;
		timeout.tv_usec=1;

		if( (n=select(maxfd, &rset, NULL, NULL, &timeout)) <0) write(1, "select error\n", 13);

		if( FD_ISSET(fd, &rset) )
		{
			n = read(fd, &iac_buff, 1);
				if( n==0 ) abnormal_disconnect(fd);
			if( iac_buff != IAC ) return(-2);
				/*garbage code received*/
		}
		else
			return(0);	/*no data-in*/	

		/*continue at fix_read the head*/
	}
	else
	{
		do
		{ 
			n=read(fd, &iac_buff, 1); 
			if( n==0 ) abnormal_disconnect(fd);
		} while( iac_buff != IAC );
			/*skip until IAC appearred*/
	}

	fix_read(fd, 1, (char*) &(mpf_head.prot));
	fix_read(fd, 8, (char*) mpf_head.length);
		/*get packet head*/

	*protocol = mpf_head.prot;
	sscanf(mpf_head.length, "%ld", buf_len);

	if( *buf_len > 0 )	/*get the packet body if exist*/
	{
		/***************************************************/
		/* if show readmpf status line when reading network*/
		/***************************************************/
		switch(mpf_head.prot)
		{
		case DISPLAY:
		case FILEPOST:
		case INTRREAD:
		case INTRSEL:
		case MAKEPOST:
		case POST:
			show_readmpf_status=TRUE;
			break;

		default:
			show_readmpf_status=FALSE;
			break;
		}

		/* skip show status if short packet*/
		if( show_readmpf_status && (*buf_len<1024) )
			show_readmpf_status=FALSE;
		/***************************************************/

		fix_read(fd, *buf_len, buffer);
	}/*end if*/

	return(1);	/*OK*/
}
/*end of read_mpf*/
	
