/************************************************************************
        PowerBBS Client NF Module (Not-Flexible)
        by Samson Chen
        Oct 28, 1994
 ************************************************************************/

#include <varargs.h>
#include "pbbs.h"
#include "msg.h"

static char rcsid[]="$Id: popmenu.c,v 1.1 1995/11/11 08:47:27 pbbs Exp pbbs $" ;

char *kkytok();         /*prototype*/

char *menu1[]={MENU10, MENU11, MENU12, MENU13, MENU14, MENU15, MENU16, MENU17};
char *menu2[]={MENU20, MENU21, MENU22, MENU23};
char *menu3[]={MENU30, MENU31, MENU32, MENU33, MENU34, MENU35, MENU36, MENU37, MENU38};
char *menu4[]={MENU40, MENU41, MENU42, MENU43, MENU44};
char *menu5[]={MENU50, MENU51, MENU52, MENU53, MENU54, MENU55, MENU56, MENU57, MENU58};


/*
        pop_menu --- pop up main menu
*/
pop_menu()
        /*
          return: >0  : ASCII
                   0  : request protocol sent
        */
{
        int key;
        int i;
        char clean[80];
        char sprompt[50];
        static int item1=1, item2=1, item3=1, item4=1, item5=1;
        static int current_menu=1;
        int item;
        char user_select=FALSE;
        int get_key;
        char user_key;
        char direct_press;

        normal_text();

        show_menu(5, FALSE);
        show_menu(4, FALSE);
        show_menu(3, FALSE);
        show_menu(2, FALSE);
        show_menu(1, FALSE);

	if( !expert_mode )
	{
          if( !term_mode )
          {
                gotoxy(5, 23); flush_printf("^D : Shell");
                gotoxy(5, 24); flush_printf("^O : Change Download Path");
          }

	  gotoxy(34, 24); flush_printf("@ : Expert Mode");
	}
	else
	{
	  gotoxy(34, 24); flush_printf("@ : Novice Mode");
	}


        direct_press=FALSE;

        do
        {
          switch(current_menu)
          {
          case 1:

            /*************************************************************
             * MENU 1 Operation
             *************************************************************/

            show_menu(1, TRUE);

            get_key=FALSE;
            do
            {
	      if( !expert_mode )
	      {
		sprintf(sprompt, "%s%s", MENUSEL, menu1[item1]);
		sprompt[strlen(sprompt)-1]=0;     /*strip quick key display*/
		gotoxy(1, 11);
		flush_printf("%s", sprompt);
	      }

              if( direct_press )
              {
                /*user select a function by key or mouse directly*/
                get_key=TRUE;
                user_select=TRUE;
                continue;
              }

              inverse_text();
	      gotoxy(6, 14+item1);
	      flush_printf("%s", menu1[item1]);

              do
              {
                get_key=get_user_input(1, &user_key);

                if(get_key==5)  /*key input*/
                  if( !valid_key_check(user_key) )
                    continue;

                break;

              }while(TRUE);

              normal_text();
              gotoxy(6, 14+item1);

	      if( !expert_mode )
		flush_printf("%s", menu1[item1]);
	      else
	      {
		sprintf(sprompt, "%s", menu1[item1]);
		sprompt[strlen(sprompt)-1]=' ';     /*strip quick key display*/
		flush_printf("%s", sprompt);
	      }

              switch(get_key)
              {
              case 0:   /*enter*/
                map_menu(&user_key, current_menu, item1);
                get_key=TRUE;
                user_select=TRUE;
                break;

              case 1:   /*up*/
                item1--;
                if( item1<=0 )
                        item1=7;
                get_key=FALSE;
                break;

              case 2:   /*down*/
                item1++;
                if( item1>=8 )
                        item1=1;
                get_key=FALSE;
                break;

              case 3:   /*right*/
                current_menu=2;
                break;

              case 4:   /*left*/
                current_menu=5;
                break;

              case 5:   /*key input*/
                if( user_key==4 || user_key==15 || user_key=='@' )
                  user_select=TRUE;
                else
                {
                  map_key(&current_menu, &item1, &item2, &item3, &item4, &item5, user_key);
                  direct_press=TRUE;
                }

                break;

              default:
                        get_key=FALSE;
                        break;

              }/*end of switch*/

            }while(!get_key);

            down_menu(1);
            break;

          case 2:

            /*************************************************************
             * MENU 2 Operation
             *************************************************************/

            show_menu(2, TRUE);

            get_key=FALSE;
            do
            {
	      if( !expert_mode )
	      {
		sprintf(sprompt, "%s%s", MENUSEL, menu2[item2]);
		sprompt[strlen(sprompt)-1]=0;     /*strip quick key display*/
		gotoxy(1, 11);
		flush_printf("%s", sprompt);
	      }

              if( direct_press )
              {
                /*user select a function by key directly*/
                get_key=TRUE;
                user_select=TRUE;
                continue;
              }

              inverse_text();
              gotoxy(20, 15+item2);
              flush_printf("%s", menu2[item2]);

              do
              {
                get_key=get_user_input(2, &user_key);

                if(get_key==5)  /*key input*/
                  if( !valid_key_check(user_key) )
                    continue;

                break;

              }while(TRUE);

              normal_text();
	      gotoxy(20, 15+item2);

	      if( !expert_mode )
		flush_printf("%s", menu2[item2]);
	      else
	      {
		sprintf(sprompt, "%s", menu2[item2]);
		sprompt[strlen(sprompt)-1]=' ';     /*strip quick key display*/
		flush_printf("%s", sprompt);
	      }

              switch(get_key)
              {
              case 0:   /*enter*/
                map_menu(&user_key, current_menu, item2);
                get_key=TRUE;
                user_select=TRUE;
                break;

              case 1:   /*up*/
                item2--;
                if( item2<=0 )
                        item2=3;
                get_key=FALSE;
                break;

              case 2:   /*down*/
                item2++;
                if( item2>=4 )
                        item2=1;
                get_key=FALSE;
                break;

              case 3:   /*right*/
                current_menu=3;
                break;

              case 4:   /*left*/
                current_menu=1;
                break;

              case 5:   /*key input*/
                if( user_key==4 || user_key==15 || user_key=='@' )
                  user_select=TRUE;
                else
                {
                  map_key(&current_menu, &item1, &item2, &item3, &item4, &item5, user_key);
                  direct_press=TRUE;
                }

                break;

              default:
                        get_key=FALSE;
                        break;

              }/*end of switch*/

            }while(!get_key);

            down_menu(2);
            break;

          case 3:

            /*************************************************************
             * MENU 3 Operation
             *************************************************************/

            show_menu(3, TRUE);

            get_key=FALSE;
            do
            {
	      if( !expert_mode )
	      {
		sprintf(sprompt, "%s%s", MENUSEL, menu3[item3]);
		sprompt[strlen(sprompt)-1]=0;     /*strip quick key display*/
		gotoxy(1, 11);
		flush_printf("%s", sprompt);
	      }

              if( direct_press )
              {
                /*user select a function by key directly*/
                get_key=TRUE;
                user_select=TRUE;
                continue;
              }

              inverse_text();
              gotoxy(34, 14+item3);
              flush_printf("%s", menu3[item3]);

              do
              {
                get_key=get_user_input(3, &user_key);

                if(get_key==5)  /*key input*/
                  if( !valid_key_check(user_key) )
                    continue;

                break;

              }while(TRUE);

              normal_text();
              gotoxy(34, 14+item3);

	      if( !expert_mode )
		flush_printf("%s", menu3[item3]);
	      else
	      {
		sprintf(sprompt, "%s", menu3[item3]);
		sprompt[strlen(sprompt)-1]=' ';     /*strip quick key display*/
		flush_printf("%s", sprompt);
	      }

              switch(get_key)
              {
              case 0:   /*enter*/
                map_menu(&user_key, current_menu, item3);
                get_key=TRUE;
                user_select=TRUE;
                break;

              case 1:   /*up*/
                item3--;
                if( item3<=0 )
                        item3=8;
                get_key=FALSE;
                break;

              case 2:   /*down*/
                item3++;
                if( item3>=9 )
                        item3=1;
                get_key=FALSE;
                break;

              case 3:   /*right*/
                current_menu=4;
                break;

              case 4:   /*left*/
                current_menu=2;
                break;

              case 5:   /*key input*/
                if( user_key==4 || user_key==15 || user_key=='@' )
                  user_select=TRUE;
                else
                {
                  map_key(&current_menu, &item1, &item2, &item3, &item4, &item5, user_key);
                  direct_press=TRUE;
                }

                break;

              default:
                        get_key=FALSE;
                        break;

              }/*end of switch*/

            }while(!get_key);

            down_menu(3);
            break;

          case 4:

            /*************************************************************
             * MENU 4 Operation
             *************************************************************/

            show_menu(4, TRUE);

            get_key=FALSE;
            do
            {
	      if( !expert_mode )
	      {
		sprintf(sprompt, "%s%s", MENUSEL, menu4[item4]);
		sprompt[strlen(sprompt)-1]=0;     /*strip quick key display*/
		gotoxy(1, 11);
		flush_printf("%s", sprompt);
	      }

              if( direct_press )
              {
                /*user select a function by key directly*/
                get_key=TRUE;
                user_select=TRUE;
                continue;
              }

              inverse_text();
              gotoxy(48, 15+item4);
              flush_printf("%s", menu4[item4]);

              do
              {
                get_key=get_user_input(4, &user_key);

                if(get_key==5)  /*key input*/
                  if( !valid_key_check(user_key) )
                    continue;

                break;

              }while(TRUE);

              normal_text();
              gotoxy(48, 15+item4);

	      if( !expert_mode )
		flush_printf("%s", menu4[item4]);
	      else
	      {
		sprintf(sprompt, "%s", menu4[item4]);
		sprompt[strlen(sprompt)-1]=' ';     /*strip quick key display*/
		flush_printf("%s", sprompt);
	      }

              switch(get_key)
              {
              case 0:   /*enter*/
                map_menu(&user_key, current_menu, item4);
                get_key=TRUE;
                user_select=TRUE;
                break;

              case 1:   /*up*/
                item4--;
                if( item4<=0 )
                        item4=4;
                get_key=FALSE;
                break;

              case 2:   /*down*/
                item4++;
                if( item4>=5 )
                        item4=1;
                get_key=FALSE;
                break;

              case 3:   /*right*/
                current_menu=5;
                break;

              case 4:   /*left*/
                current_menu=3;
                break;

              case 5:   /*key input*/
                if( user_key==4 || user_key==15 || user_key=='@' )
                  user_select=TRUE;
                else
                {
                  map_key(&current_menu, &item1, &item2, &item3, &item4, &item5, user_key);
                  direct_press=TRUE;
                }

                break;

              default:
                        get_key=FALSE;
                        break;

              }/*end of switch*/

            }while(!get_key);

            down_menu(4);
            break;

          case 5:

            /*************************************************************
             * MENU 5 Operation
             *************************************************************/

            show_menu(5, TRUE);

            get_key=FALSE;
            do
            {
	      if( !expert_mode )
	      {
		sprintf(sprompt, "%s%s", MENUSEL, menu5[item5]);
		sprompt[strlen(sprompt)-1]=0;     /*strip quick key display*/
		gotoxy(1, 11);
		flush_printf("%s", sprompt);
	      }

              if( direct_press )
              {
                /*user select a function by key directly*/
                get_key=TRUE;
                user_select=TRUE;
                continue;
              }

              inverse_text();
              gotoxy(62, 14+item5);
              flush_printf("%s", menu5[item5]);

              do
              {
                get_key=get_user_input(5, &user_key);

                if(get_key==5)  /*key input*/
                  if( !valid_key_check(user_key) )
                    continue;

                break;

              }while(TRUE);

              normal_text();
              gotoxy(62, 14+item5);

	      if( !expert_mode )
		flush_printf("%s", menu5[item5]);
	      else
	      {
		sprintf(sprompt, "%s", menu5[item5]);
		sprompt[strlen(sprompt)-1]=' ';     /*strip quick key display*/
		flush_printf("%s", sprompt);
	      }

              switch(get_key)
              {
              case 0:   /*enter*/
                map_menu(&user_key, current_menu, item5);
                get_key=TRUE;
                user_select=TRUE;
                break;

              case 1:   /*up*/
                item5--;
                if( item5<=0 )
                        item5=8;
                get_key=FALSE;
                break;

              case 2:   /*down*/
                item5++;
                if( item5>=9 )
                        item5=1;
                get_key=FALSE;
                break;

              case 3:   /*right*/
                current_menu=1;
                break;

              case 4:   /*left*/
                current_menu=4;
                break;

              case 5:   /*key input*/
                if( user_key==4 || user_key==15 || user_key=='@' )
                  user_select=TRUE;
                else
                {
                  map_key(&current_menu, &item1, &item2, &item3, &item4, &item5, user_key);
                  direct_press=TRUE;
                }
                break;

              default:
                        get_key=FALSE;
                        break;

              }/*end of switch*/

            }while(!get_key);

            down_menu(5);
            break;

          }
        }while( !user_select);

	if( !expert_mode && user_key=='@' )	/*switch to expert mode*/
	{
		sprintf(sprompt, "%s@            ", MENUSEL);
		gotoxy(1, 11);
		flush_printf("%s", sprompt);
	}

        /*clear popmenus and return to normal mode*/
        normal_text();
	if( !expert_mode )
	{
          memset(clean, ' ', 79);
          clean[79]=0;
          for(i=12; i<=24; i++)
          {
                gotoxy(1, i);
                flush_printf("%s", clean);
          }
          gotoxy(1,12);
	}
	else
	{
          show("{#c#}");        /*clrscr*/
	}


        return(user_key);

}
/*end of pop_menu*/



/*
        get_user_input --- keyboard or mouse
*/
get_user_input(cmenu, ukey)
        int cmenu;      /*current menu*/
        char *ukey;
/*
        RETURN:
                0       enter
                1       up
                2       down
                3       right
                4       left
                5       user key (put in ukey)
                10      item[1]
                20      item[2]
                30      item[3]
                ...
                1000    jump to menu1
                2000    jump to menu2
                3000    jump to menu3
                ...
*/
{
        int x,y,a,b;
        int ret;
        int key;

        ret=0;

        gotoxy(79,25);  /*when press [->] in chinese...skip this problem*/

        do
        {

            key=readkey();

            if( key==27 )
            {
              key=readkey();

              if( key=='[' || key=='O'  || key=='0' )
              {
                key=readkey();

                if( key=='A' )     /*up*/
                  ret=1;

                if( key=='C' )     /*right*/
                  ret=3;

                if( key=='D' )     /*left*/
                  ret=4;

                if( key=='B' )     /*down*/
                  ret=2;
              }

              continue;

            }/*endif arrowkey*/

            key=toupper(key);
            if( key==13 || key==10 )
                return(0);

            if( valid_key_check(key) )
            {
                *ukey=key;
                ret=5;
            }

            continue;


        }while(ret==0);

        return(ret);

}
/*end of get_user_input*/



/*
        map_menu --- map menu item to quick key
*/
map_menu(key, menu, item)
        char *key;      /*mapped key*/
        int menu;
        int item;
{
        switch(menu)
        {
        case 1:         /*menu1*/
          switch(item)
          {
          case 1:
            *key='J';
            break;
          case 2:
            *key='Q';
            break;
          case 3:
            *key='I';
            break;
          case 4:
            *key='F';
            break;
          case 5:
            *key='P';
            break;
          case 6:
            *key='R';
            break;
          case 7:
            *key='E';
            break;
          default:
            *key='H';
            break;
          }
          break;

        case 2:         /*menu2*/
          switch(item)
          {
          case 1:
            *key='N';
            break;
          case 2:
            *key='Y';
            break;
          case 3:
            *key='A';
            break;
          default:
            *key='H';
            break;
          }
          break;

        case 3:         /*menu3*/
          switch(item)
          {
          case 1:
            *key='B';
            break;
          case 2:
            *key='V';
            break;
          case 3:
            *key='H';
            break;
          case 4:
            *key='W';
            break;
          case 5:
            *key='C';
            break;
          case 6:
            *key='X';
            break;
          case 7:
            *key='G';
            break;
          case 8:
            *key='!';
            break;
          default:
            *key='H';
            break;
          }
          break;

        case 4:         /*menu4*/
          switch(item)
          {
          case 1:
            *key='T';
            break;
          case 2:
            *key='O';
            break;
          case 3:
            *key='D';
            break;
          case 4:
            *key='U';
            break;
          default:
            *key='H';
            break;
          }
          break;

        case 5:         /*menu5*/
          switch(item)
          {
          case 1:
            *key='S';
            break;
          case 2:
            *key='*';
            break;
          case 3:
            *key='$';
            break;
          case 4:
            *key='#';
            break;
          case 5:
            *key='%';
            break;
          case 6:
            *key='Z';
            break;
          case 7:
            *key='K';
            break;
          case 8:
            *key='M';
            break;
          default:
            *key='H';
            break;
          }
          break;

        default:
          *key='H';
          break;
        }

        return(0);
}
/*end of map_menu*/



/*
        map_key --- map keu to menu item
*/
map_key(menu, item1, item2, item3, item4, item5, key)
        int *menu;
        int *item1;
        int *item2;
        int *item3;
        int *item4;
        int *item5;
        char key;
{
        switch(key)
        {
        /*--- menu1 ---*/

        case 'J':
                *menu=1;
                *item1=1;
                break;

        case 'Q':
                *menu=1;
                *item1=2;
                break;

        case 'I':
                *menu=1;
                *item1=3;
                break;

        case 'F':
                *menu=1;
                *item1=4;
                break;

        case 'P':
                *menu=1;
                *item1=5;
                break;

        case 'R':
                *menu=1;
                *item1=6;
                break;

        case 'E':
                *menu=1;
                *item1=7;
                break;

        /*--- menu2 ---*/

        case 'N':
                *menu=2;
                *item2=1;
                break;

        case 'Y':
                *menu=2;
                *item2=2;
                break;

        case 'A':
                *menu=2;
                *item2=3;
                break;

        /*--- menu3 ---*/

        case 'B':
                *menu=3;
                *item3=1;
                break;

        case 'V':
                *menu=3;
                *item3=2;
                break;

        case 'H':
                *menu=3;
                *item3=3;
                break;

        case 'W':
                *menu=3;
                *item3=4;
                break;

        case 'C':
                *menu=3;
                *item3=5;
                break;

        case 'X':
                *menu=3;
                *item3=6;
                break;

        case 'G':
                *menu=3;
                *item3=7;
                break;

        case '!':
                *menu=3;
                *item3=8;
                break;

        /*--- menu4 ---*/

        case 'T':
                *menu=4;
                *item4=1;
                break;

        case 'O':
                *menu=4;
                *item4=2;
                break;

        case 'D':
                *menu=4;
                *item4=3;
                break;

        case 'U':
                *menu=4;
                *item4=4;
                break;

        /*--- menu5 ---*/

        case 'S':
                *menu=5;
                *item5=1;
                break;

        case '*':
                *menu=5;
                *item5=2;
                break;

        case '$':
                *menu=5;
                *item5=3;
                break;

        case '#':
                *menu=5;
                *item5=4;
                break;

        case '%':
                *menu=5;
                *item5=5;
                break;

        case 'Z':
                *menu=5;
                *item5=6;
                break;

        case 'K':
                *menu=5;
                *item5=7;
                break;

        case 'M':
                *menu=5;
                *item5=8;
                break;

        /*--- set default to HELP function ---*/

        default:
                *menu=3;
                *item3=3;
                break;
        }

        return(0);
}
/*end of map_key*/



/*
        valid_key_check --- check if key valid
*/
valid_key_check(key)
        int key;
/*
        RETURN: TRUE: OK
                FALSE: not allowed key
*/
{
        int ret;

        switch(key)
        {
                case  4 :       /*ctrl-D*/
                case 13 :       /*[Enter]*/
                case 15 :       /*ctrl-O*/
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '!':
                case '*':
                case '$':
                case '#':
                case '%':
		case '@':
                        ret=TRUE;
                        break;

                default:
                        ret=FALSE;
                        break;
        }

        return(ret);
}
/*end of valid_key_check*/



/*
        get bolder style
*/
get_bolder(up, bup, bsp, bmd, bdn)
        char up;        /*up or down*/
        char *bup;
        char *bsp;
        char *bmd;
        char *bdn;
{
        if(up)
        {
                strcpy(bup, UBOLDUP);
                strcpy(bsp, UBOLDSP);
                strcpy(bmd, UBOLDMD);
                strcpy(bdn, UBOLDDN);
        }
        else
        {
                strcpy(bup, DBOLDUP);
                strcpy(bsp, DBOLDSP);
                strcpy(bmd, DBOLDMD);
                strcpy(bdn, DBOLDDN);
        }

        return(0);
}
/*end of get_bolder*/



/*
        put_bolder --- draw bolder lines
*/
put_bolder(cx, cy, size, bup, bsp, bmd, bdn)
        int cx;         /*conner X*/
        int cy;         /*conner Y*/
        int size;       /*lines*/
        char *bup;
        char *bsp;
        char *bmd;
        char *bdn;
{
        int i;

        /*draw bolder*/
        gotoxy(cx, cy);
        flush_printf("%s", bup);
        gotoxy(cx, cy+1);
        flush_printf("%s", bmd);
        gotoxy(cx, cy+2);
        flush_printf("%s", bsp);

        for(i=1; i<=size; i++)
        {
                gotoxy(cx, cy+2+i);
                flush_printf("%s", bmd);
        }

        gotoxy(cx, cy+2+size+1);
        flush_printf("%s", bdn);

        return(0);
}
/*end of put_bolder*/



/*
        show_menu
*/
show_menu(smenu, up)
        int smenu;
        char up;        /*up or down*/
{
        char bup[50], bsp[50], bmd[50], bdn[50];
        char v[3];
        int cx,cy,h;
        int i;

	if( expert_mode )
	  return(0);

        switch(smenu)
        {
        case 1:
                cx=4;
                cy=12;
                h=7;
                break;
        case 2:
                cx=18;
                cy=13;
                h=3;
                break;
        case 3:
                cx=32;
                cy=12;
                h=8;
                break;
        case 4:
                cx=46;
                cy=13;
                h=4;
                break;
        case 5:
                cx=60;
                cy=12;
                h=8;
                break;
        }

        get_bolder(up, bup, bsp, bmd, bdn);
        put_bolder(cx, cy, h, bup, bsp, bmd, bdn);


        gotoxy(cx+2, cy+1);

        switch(smenu)
        {
        case 1:
                flush_printf("%s", menu1[0]);
                break;
        case 2:
                flush_printf("%s", menu2[0]);
                break;
        case 3:
                flush_printf("%s", menu3[0]);
                break;
        case 4:
                flush_printf("%s", menu4[0]);
                break;
        case 5:
                flush_printf("%s", menu5[0]);
                break;
        }

        for(i=1; i<=h; i++)
        {
                gotoxy(cx+2, cy+2+i);

                switch(smenu)
                {
                case 1:
                        flush_printf("%s", menu1[i]);
                        break;
                case 2:
                        flush_printf("%s", menu2[i]);
                        break;
                case 3:
                        flush_printf("%s", menu3[i]);
                        break;
                case 4:
                        flush_printf("%s", menu4[i]);
                        break;
                case 5:
                        flush_printf("%s", menu5[i]);
                        break;
                }
        }

        return(0);

}
/*end of show_menu*/



/*
        down_menu --- draw just down bolder
*/
down_menu(dmenu)
        int dmenu;
{
        char v[3];
        int cx,cy,h;
        int i;

	if( expert_mode )
	  return(0);

        strncpy(v, DBOLDMD, 2);
        v[2]=0;

        switch(dmenu)
        {
        case 1:
                cx=4;
                cy=12;
                h=7;
                break;
        case 2:
                cx=18;
                cy=13;
                h=3;
                break;
        case 3:
                cx=32;
                cy=12;
                h=8;
                break;
        case 4:
                cx=46;
                cy=13;
                h=4;
                break;
        case 5:
                cx=60;
                cy=12;
                h=8;
                break;
        }

        /*draw bolder*/
        gotoxy(cx, cy);
        flush_printf("%s", DBOLDUP);

        gotoxy(cx, cy+1);
        flush_printf("%s", v);
        gotoxy(cx+16, cy+1);
        flush_printf("%s", v);

        gotoxy(cx, cy+2);
        flush_printf("%s", DBOLDSP);

        for(i=1; i<=h; i++)
        {
                gotoxy(cx, cy+2+i);
                flush_printf("%s", v);
                gotoxy(cx+16, cy+2+i);
                flush_printf("%s", v);
        }

        gotoxy(cx, cy+2+h+1);
        flush_printf("%s", DBOLDDN);

        return(0);
}
/*end of down_menu*/



/*
        set inverse text color
*/
inverse_text()
{
        fprintf(stdout, "%c[%dm", 27, 7);
}
/*end of inverse_text*/



/*
       set normal text color
*/
normal_text()
{
        fprintf(stdout, "%c[%dm", 27, 0);
}
/*end if normal_text*/



/*
        map_key_menuprotocol --- map key to menu protocol string
*/
map_key_menuprotocol(menups, ukey)
        char *menups;
        char ukey;
/*
        RETURN: TRUE    ok (result in menups)
                FALSE   ukey not defined
*/
{
        int ret;

        ret=TRUE;

        switch(ukey)
        {
                case 'A':
                  strcpy(menups, "{Send_Email}");
                  break;
                case 'B':
                  strcpy(menups, "{Bulletin}");
                  break;
                case 'C':
                  strcpy(menups, "{Chat_Room}");
                  break;
                case 'D':
                  strcpy(menups, "{Download_File}");
                  break;
                case 'E':
                  strcpy(menups, "{Enter_Mail}");
                  break;
                case 'F':
                  strcpy(menups, "{File_Post}");
                  break;
                case 'G':
                  strcpy(menups, "{Internet}");
                  break;
                case 'H':
                  strcpy(menups, "{Help_Main}");
                  break;
                case 'I':
                  strcpy(menups, "{Inter_Read}");
                  break;
                case 'J':
                  strcpy(menups, "{Change_Area}");
                  break;
                case 'K':
                  strcpy(menups, "{Power_Net}");
                  break;
                case 'M':
                  strcpy(menups, "{More_Functions}");
                  break;
                case 'N':
                  strcpy(menups, "{Read_Mbox}");
                  break;
                case 'O':
                  strcpy(menups, "{Reset_Toggle}");
                  break;
                case 'P':
                  strcpy(menups, "{Previous_Mail}");
                  break;
                case 'Q':
                  strcpy(menups, "{Quick_Join}");
                  break;
                case 'R':
                  strcpy(menups, "{Read_Mail}");
                  break;
                case 'S':
                  strcpy(menups, "{List_Users}");
                  break;
                case 'T':
                  strcpy(menups, "{Toggle_File}");
                  break;
                case 'U':
                  strcpy(menups, "{Upload_File}");
                  break;
                case 'V':
                  strcpy(menups, "{Version_Info}");
                  break;
                case 'W':
                  strcpy(menups, "{Welcome}");
                  break;
                case 'X':
                  strcpy(menups, "{Write_User}");
                  break;
                case 'Y':
                  strcpy(menups, "{Send_Mbox}");
                  break;
                case 'Z':
                  strcpy(menups, "{Zap_Area}");
                  break;
                case '!':
                  strcpy(menups, "{Goodbye}");
                  break;
                case '*':
                  strcpy(menups, "{Password}");
                  break;
                case '$':
                  strcpy(menups, "{UP_Data}");
                  break;
                case '#':
                  strcpy(menups, "{Ping}");
                  break;
                case '%':
                  strcpy(menups, "{Switch_Page}");
                  break;

                default:
                        ret=FALSE;
                        break;
        }

        return(ret);
}
/*end of map_key_menuprotocol*/



/*
        yesno_confirm --- get yes/no from user
*/
yesno_confirm(buf)
        char *buf;
/*
        the answer 'y' or 'n' put in buf[0]
*/
{
        char answer;
	char line[10];

        show(buf);

        do
        {
           answer=tolower(readkey());
           if( answer=='y' || answer=='n' )
                 break;
        } while(TRUE);

	sprintf(line, "%c\n", toupper(answer));
        show(line);

        buf[0]=answer;

        return(0);
}
/*end of yesno_confirm*/



/*
        internet --- call 'telnet' to another place in the net
*/
void internet(site, login)
	char *site;
	char *login;
{
        char shell_line[80];

        show("\n");
        show(INET1);
        show(site);
        show("\n");
        show(INET2);
        show(login);

        show("\n");
        show(PRESSANYKEY) ;
        readkey();
        show("\n");

        /*call telnet*/
        sprintf(shell_line, "telnet %s", site);
        end_terminal() ;
        system(shell_line) ;
        init_terminal() ;
}
/*end of internet*/



/*
        flush_printf --- printf then flush it
*/
flush_printf(logformat, va_alist)
        char *logformat;
        va_dcl
{
        char msg[600];

        /*get arguments list*/
        va_list args;
        va_start(args);
        vsprintf(msg, logformat, args);
        va_end(args);

        printf("%s", msg);
        fflush(stdout);
}
/*end of flush_printf*/

