/***************************************************************
    pclient.c

    To connect the BBS server.
    write by Aquarius Kuo(cs79026@chpi.edu.tw)
    1993.11.24.

    version 2 remodified by Samson Chen(samson@chpi.edu.tw)
    1994.11.18

    version 2.1 remodified by Jones Tsai(cs80292@chpi.edu.tw)
    1995.3.28
    1995.4.19

    version 2.2 by Samson Chen
    1995.4.21
    1995.4.26

    version 2.2a by Samson Chen
    1995.5.30

    version 2.2b by Samson Chen
    1995.6.27

    version 2.3 by Samson Chen
    1995.8.16

    version 2.3a by Samson Chen
    1995.11.10
    1995.11.22
    1995.12.30
*****************************************************************/
#include <curses.h>
#include <ctype.h>
#include <fcntl.h>              /* jones */
#include "pbbs.h"
#include "msg.h"

#define LEFT    '{'
#define RIGHT   '}'
#define SEP     '|'
#define VERSION  (char) 0x23

#ifdef  SUN4
#define PLATFORM (char) 1
#endif

#ifdef  NETBSD
#define PLATFORM (char) 3
#endif

#ifdef RS6K
#define PLATFORM (char) 4
#endif

#ifdef DEC3K
#define PLATFORM (char) 5
#endif

#ifdef HPPA
#define PLATFORM (char) 6
#endif

#ifdef ALPHA
#define PLATFORM (char) 7
#endif

#ifdef LINUX
#define PLATFORM (char) 8
#endif

#ifdef FREEBSD
#define PLATFORM (char) 12
#endif

#ifdef IRIX
#define PLATFORM (char) 13
#endif

#ifndef PLATFORM
#define PLATFORM (char) 15
#endif

static char rcsid[]="$Id: pclient.c,v 1.3 1995/11/11 12:01:30 pbbs Exp pbbs $" ;

char *kkytok();         /*prototype*/

char    SELECTMSG[80] ;
int term_mode=0 ;
char capfn[80] ;
int SCR_ROWS, SCR_COLS ;
char success_then_remove;
char s_t_r_filename[80];
int intrread_point=0;
char expert_mode=FALSE;	/*expert mode menu*/
char iread_mark[51];	/*color mark for intrread*/

/*for multi-layer INTRSEL point stack*/
int isel_point_stk[256];  /*ASC 49 (1) --- ASC 255 : 207 layers max*/



/*--- To close the connection & exit ---*/
void hang_up(msg,fd)
char *msg ;
int fd ;
{
  printf("\n\r%s\n\r",msg) ;
  close(fd) ;
  end_terminal() ;
  exit(1) ;
}

/*--- To close the connection & exit ---*/
void abnormal_disconnect(fd)
int fd ;
{
  printf("\n\rThe server closed the connection!!\n\r") ;
  if( success_then_remove )
  {
        printf("%s %s, %s\n\r", S_T_R_MSG, s_t_r_filename, PRESSANYKEY);
        readkey();
        success_then_remove=FALSE;      /*prevent from dup display*/
  }

  close(fd) ;
  end_terminal() ;
  exit(1) ;
}


/*
	Make PowerBBS Session
*/
make_pbbs_session(ipaddr, bbsport)
  char *ipaddr;
  int bbsport;
{
  int fd;
  char buffer[256];
  long len ;
  char prot ;

  fd=connectTCP(ipaddr, bbsport);
  strcpy(buffer,"Samson") ;
  send_mpf(fd,buffer,strlen(buffer),SESSION,FALSE) ;

  read_mpf(fd, buffer, &len, &prot, FALSE);
  buffer[len]=0 ;
  if(strcmp("Aquarius",buffer))
  {
    printf("handshaking error with PBBS server!\n");
    exit(1);
  }
  buffer[0]=VERSION ;         /* VER_HIGH<<4+VER_LOW ;*/
  buffer[1]=(PLATFORM<<4)+0 ;   /* 1*16+0 ;*/

  len=10;
  strcpy(&buffer[2],"POWERBBS") ;
  if( term_mode )
  {
    get_tty_src(buffer+11);
    len+=strlen(buffer+11)+1;
  }
  send_mpf(fd, buffer, len, SESSION) ;

  return(fd);
}
/*end of make_pbbs_session*/



/*========================Main program ============================*/
main(argc, argv)
int argc;
char *argv[];
{
  int fd ;
  long len, read_len ;
  char prot ;
  char ipaddr[50] ;
  int  bbsport ;
  int quit, out_getkey, i, tcpstat ;
  int mils, cnt ;
  struct timeval start_time, end_time ;
  char key ;
  char editor[120], LOCAL_DIR[120] ;
  char header[500] ;
  char intrread_buf[BACK_BUF], intrsel_buf[MAX_BUF];
  char buffer[MAX_BUF], pwbuffer[20] ;
  char menu_buf[2048];
  char menu_protocol[80];
  FILE *fp;                     /* new, use at open .pbbsrc*/
  char fname[120];              /* new, .pbbsrc pathname */
  char envname[128];            /* new, temporarily save env name */
  char envval[128];             /* new, temporarily save env value */
  char *sptr;                   /* new, string pointer */
  char answer[80];
  char crlf[3];
  char *site;
  char *login;


  extern int broken_pipe();     /*when client and server run under the same*/
                                /*host, network will use PIPE to communicate*/

  printf("\r\n\n PowerBBS UNIX client\n\r") ;
  printf("   by Aquarius Kuo, Team SQUARE-1991, Jul 11, 1994.\n") ;
  printf("%s", CLIENT_VER_NOTE2+6);

  fflush(stdout) ;


  /* initial isel_point_stk */
  for(cnt=0; cnt<256; cnt++)
	isel_point_stk[cnt]=0;


  /* Search .pbbsrc path */

  sprintf(fname,"%s%s%c",getenv("HOME"),"/.pbbsrc",0);
  /*  printf("%s\n\n",fname);  */
  if (!file_exist(fname))
   {
    sprintf(fname,"%s%s%c","/etc","/.pbbsrc",0);
    if (!file_exist(fname))
     {
      sprintf(fname,"%s%s%c","/usr/local/etc","/.pbbsrc",0);
      if (!file_exist(fname))
       {

        /* Create default .pbbsrc */

        printf(" Cannot find .pbbsrc file, would you like to create it? (Y/N)");
        fgets(answer, 10, stdin);
        key=tolower(answer[0]);

        if( key!='y' )
        {
          printf(" Cannot find .pbbsrc !! \n\7\n");
          exit(1);
        }

        sprintf(fname,"%s%s%c",getenv("HOME") ,"/.pbbsrc",0);
        printf(" Create %s\n", fname);
        printf(" You can change your preference by modifying it!\n\n");

        if ( (fp=fopen(fname,"w"))!=NULL )
         {
          fprintf(fp,"%s:\t\t%s\n","pbbs_server",PBBS_DEFAULT_SERVER);
          fprintf(fp,"%s:\t\t%d\n","pbbs_port",PBBS_DEFAULT_PORT);

          if( getenv("EDITOR")!=NULL )
            fprintf(fp,"%s:\t\t%s\n","pbbs_edit",getenv("EDITOR"));
          else if(getenv("VISUAL")!=NULL )
            fprintf(fp,"%s:\t\t%s\n","pbbs_edit",getenv("VISUAL"));
          else
            fprintf(fp,"%s:\t\t%s\n","pbbs_edit","vi");

          fprintf(fp,"%s:\t\t%s\n","pbbs_termmode","NO");
          fprintf(fp,"%s:\t\t\n","pbbs_downpath");
          fclose(fp);

          printf(" Please press [ENTER] to continue...");
          fgets(answer, 10, stdin);
         }
        else
         {
          printf(" Cannot create .pbbsrc !! \n\7\n");
          exit(1);
         }
       }
     }
   }


  if((fp=fopen(fname,"r"))==NULL)
   {
    printf("Can't open .pbbsrc !! \n\7\n");
    exit(1);
   }

  /* Read .pbbsrc and save value to variable */

  fgets(buffer,MAX_BUF,fp);
  while (!feof(fp))
   {
    sptr=strchr(buffer,':');
    sptr++;
    while ((*sptr)==' ' || (*sptr)=='\t') sptr++;   /* remove SPACE & TAB */
    *(sptr+strlen(sptr)-1)=0;                       /* remove CR */
    strcpy(envval,sptr);
    strcpy(envname,strtok(buffer,":"));

    fgets(buffer,MAX_BUF,fp);

    if(strcmp(envname,"pbbs_server")==0)
     {
      strcpy(ipaddr,envval);
      continue;
     }

    if(strcmp(envname,"pbbs_port")==0)
     {
      bbsport=atoi(envval);
      continue;
     }

    if(strcmp(envname,"pbbs_edit")==0)
     {
      strcpy(editor,envval);
      continue;
     }

    if(strcmp(envname,"pbbs_termmode")==0)
     {
      if(strcasecmp(envval,"NO")==0)
       term_mode=0;
      else
       term_mode=1;
      continue;
     }

    if(strcmp(envname,"pbbs_downpath")==0)
     {
      strcpy(LOCAL_DIR,envval);
      continue;
     }
   }


  cnt=quit=0 ;
  if(argc>1)
  {
    if(*argv[1]=='-')
    {

      if( *(argv[1]+1)=='t' )
      {
        term_mode=1 ;
        cnt=1 ;
      }
      else
      {
        printf("Syntax:\n\r") ;
        printf("   %%p [-t] [ip_addr | domain_name] [port]\r\n\n") ;
        printf("    -t : disable disk writing.\n\n\r") ;
        exit(1) ;
      }
    }
  }

  if(argc>(1+cnt))
  {
    strncpy(ipaddr,argv[1+cnt],40) ;
    ipaddr[40]=0 ;
  }

  if(argc>(2+cnt))
  {
    bbsport=atoi(argv[2+cnt]) ;
    if(bbsport<=0)
      bbsport=PBBS_DEFAULT_PORT ;
  }

#ifdef TERMMODE
        term_mode=1 ;
#endif

(void) signal(SIGPIPE, (void *) broken_pipe);          /*see broken_pipe()*/

#ifdef TERMMODE
  printf("\n\n");
  printf("   telnet ִ PowerBBS Ļ, ޷ܵ Download\n");
  printf("  Լ Screen Capture ǿ\,  ftp  pbbs.chpi.edu.tw\n");
  printf("  ȥ PowerBBS Client ʽ!  PC , ȥץ PC\n");
  printf("  ,  PE2 дŵĿа!!!\n");
  printf("\n");
  printf("  Client  Anonymous FTP  pbbs.chpi.edu.tw \n");
  printf("\n");
  printf("     /pub/pbbs/client\n");
  printf("\n\n");
  printf("  밴 PowerBBS ϵͳ...");
#endif


  fd=make_pbbs_session(ipaddr, bbsport);

  /*--- init variable ---*/
  quit=FALSE ;

  strcpy(capfn, "cap.txt") ;

  strcpy(SELECTMSG,   "PBBS IntrSelect Title") ;

  iread_mark[0]=0;

  /*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/

  if( term_mode )
    printf(" TERMMODE ON\n\n");

  init_terminal() ;

#ifdef TERMMODE
  readkey();
  flush_printf("\n\r");
#endif

  do
  {
    if((tcpstat=read_mpf(fd,buffer,&len,&prot,FALSE))==1)
    {
      if(success_then_remove)
      {
        unlink(s_t_r_filename);
        success_then_remove=FALSE;
      }

      buffer[len]=0 ;
      switch(prot)
      {
        /*-------------------------------------------------------*/
        case ASK:
          show(buffer) ;
          i=strlen(buffer) ;
          buffer[0]=0 ;
          i=getstring(-1,-1,buffer,79-i,1) ;
          show("\n") ;
          send_mpf(fd,buffer,i,ASK) ;
          break ;
        /*-------------------------------------------------------*/
        case BYEBYE:
          quit=TRUE ;
          break ;
        /*-------------------------------------------------------*/
        case DISPLAY:
          show(buffer) ;
          break ;
        /*-------------------------------------------------------*/
        case ERROR:
          show(buffer) ;
          break ;
        /*-------------------------------------------------------*/
        case FILEPOST:
          if( term_mode )       /* not support under terminal mode */
          {
            show(FDISABLE) ;
            send_mpf(fd,buffer,1,STOPPOST) ;
            readkey() ;
            break ;
          }
          show(ASKFILENAME) ;
          buffer[0]=header[0]=0 ;
          if(getstring(-1,-1,header,30,1)<1)
          {
            send_mpf(fd,buffer,1,STOPPOST) ;
          }
          else
          {
            if( get_file(header,buffer) )
            {
              show(EDITCONFIRM) ;
              do
              {
                key=tolower(readkey()) ;

                if(key=='e')    /* edit post again */
                {
                  printf("%c",key) ;
                  fflush(stdout) ;
                  end_terminal() ;
                  if( writer(buffer,editor)==FALSE )
                  {
                    init_terminal() ;
                    send_mpf(fd,buffer,1,STOPPOST) ;
                    break ;
                  }
                  else
                  {
                    init_terminal() ;
                    erase_line();
                    show(EDITCONFIRM) ;
                  }
                }
              }
              while( (key!='p') && (key!='a') ) ;
              printf("%c",key) ;
              fflush(stdout) ;
              if(key=='p')
              {
                send_mpf(fd,buffer,strlen(buffer),MAKEPOST) ;
                break ;
              }
              else
              {
                if(key=='a')
                {
                  send_mpf(fd,buffer,1,STOPPOST) ;
                  break ;
                }
              }
            }
            else
            {
              show("\n\n") ;
              show(FNOTFOUND) ;
              readkey() ;
              send_mpf(fd,buffer,1,STOPPOST) ;
            }
          }
          break ;
        /*-------------------------------------------------------*/
        case FILEXFER:  /*DOWNLOAD*/
          if(term_mode==1)
          {
                send_mpf(fd, " ",1,STOPXFER) ;
                show("\n") ;
                show(FDISABLE) ;
                show(PRESSANYKEY) ;
                readkey() ;
                sprintf(buffer,"%c                                %c",13,13) ;
                show(buffer) ;
                show("\n") ;
          }
          else
          {

            if( LOCAL_DIR[0]!=0 )
            {
              strcpy(buffer+1024,buffer) ;
              strcpy(buffer,LOCAL_DIR) ;

              if( LOCAL_DIR[strlen(LOCAL_DIR)-1]!='/' )
                strcat(buffer,"/") ;

              strcat(buffer,buffer+1024) ;
            }

            if(download(fd,buffer,2)==FALSE)
              show(" ")  ;

          }/*end if-else (termmode)*/

          break ;
        /*-------------------------------------------------------*/
        case GETFILE:   /*UPLOAD*/
          if(term_mode==1)
          {
                send_mpf(fd, " ",1,STOPXFER) ;
                show("\n") ;
                show(FDISABLE) ;
                show(PRESSANYKEY) ;
                readkey() ;
                sprintf(buffer,"%c                                %c",13,13) ;
                show(buffer) ;
                show("\n") ;
          }
          else
          {

            if(get_filename(buffer)==FALSE)
            {
              send_mpf(fd," ",1,STOPXFER) ;
            }
            else
            {
              upload(fd,buffer,2) ;
	      show("\n");
            }

          }
          break ;
        /*-------------------------------------------------------*/
        case INTERNET:
	  /*....................................................*/
	  /* PROTOCOL format:					*/
          /*   "<site IP or domain>\crlf<login name>\crlf"	*/
	  /*   if <login name>=="PowerBBS"			*/
	  /*   <site IP> is "<address> <port>"			*/
	  /*....................................................*/

          sprintf(crlf,"%c%c",13,10) ;
	  site=kkytok(buffer,crlf) ;
	  login=kkytok(NULL,crlf) ;

	  if( !strcmp(login, "PowerBBS") )
	  {
#ifndef TERM_POWERNET
             if(term_mode==1)
             {
                show("\n") ;
                show(FDISABLE) ;
                show(PRESSANYKEY) ;
                readkey() ;
                sprintf(buffer,"%c                                %c",13,13) ;
                show(buffer) ;
                show("\n") ;
		break;
             }
#endif
	     for(cnt=0; cnt<strlen(site); cnt++)
	     {
	        if( *(site+cnt)==' ' )
	        {
		    *(site+cnt)=0;
		    login=site+cnt+1;
		    break;
		}
	     }

	     close(fd);
	     show("\nTry to connect to PowerBBS: ");
	     show(site);
	     show(".");

	     if( atoi(login)>0 )
	       show(login);
	     else
	       show("6203");

	     show("\n");

	     end_terminal() ;
	     if( atoi(login)>0 )
	       fd=make_pbbs_session(site, atoi(login));
	     else
	       fd=make_pbbs_session(site, 6203);
	     init_terminal() ;
	  }
	  else
          if(term_mode==1)
          {
                show("\n") ;
                show(FDISABLE) ;
                show(PRESSANYKEY) ;
                readkey() ;
                sprintf(buffer,"%c                                %c",13,13) ;
                show(buffer) ;
                show("\n") ;
          }
          else
		internet(site, login);
          break;
        /*-------------------------------------------------------*/
        case INTRREAD:

          if( !strcmp(buffer, "SAME_BUFFER") )
          {
                /*if Server send "SAME_BUFFER",
                  client should use the previous one*/

                strcpy(buffer, intrread_buf);
          }
          else
          {
                /*else backup the current,
                  maybe next time will use it*/

                strcpy(intrread_buf, buffer);
          }

          if((cnt=postlist(buffer, 1))>0)
          {
            sprintf(buffer,"%d",cnt) ;
            send_mpf(fd,buffer,strlen(buffer),INTRREAD) ;
          }
          else
          {
            send_mpf(fd,buffer,1,INTRREAD) ;
          }

          break ;
        /*-------------------------------------------------------*/
        case INTRSEL:

          if( !strcmp(buffer, "SAME_BUFFER") )
          {
                /*description is same as INTRREAD, but for INTRSEL*/
                strcpy(buffer, intrsel_buf);
          }
          else
          {
                strcpy(intrsel_buf, buffer);
          }

          if((cnt=postlist(buffer, 2))>0)
          {
            sprintf(buffer,"%d",cnt) ;
            send_mpf(fd,buffer,strlen(buffer),INTRSEL) ;
          }
          else
          {
            send_mpf(fd,buffer,1,INTRSEL) ;
          }
          break ;
        /*-------------------------------------------------------*/
        case MAKEPOST:
          clear_cr(buffer) ;
          clear_esc(buffer) ;
          do
          {
            end_terminal() ;
            if(writer(buffer,editor)==FALSE)
            {
              init_terminal() ;
              send_mpf(fd,buffer,0,STOPPOST) ;
              break ;
            }
            else
            {
              init_terminal() ;
              erase_line();
              show(EDITCONFIRM) ;
              do
              {
                key=tolower(readkey()) ;
              }
              while((key!='p')&&(key!='e')&&(key!='a')) ;
              printf("%c\r\n",key) ;
              fflush(stdout) ;
              if(key=='p')
              {
                send_mpf(fd,buffer,strlen(buffer),MAKEPOST) ;
                break ;
              }
              else
              {
                if(key=='a')
                {
                  send_mpf(fd,buffer,0,STOPPOST) ;
                  break ;
                }
              }
            }
          }
          while(key=='e') ;

          break ;
        /*-------------------------------------------------------*/
        case MENU:
          if( strlen(buffer)>0 )        /*new menu sent*/
                strncpy(menu_buf, buffer, 1632);

          show("{#c#}");        /*clrscr*/
          normal_text();

	  if( !expert_mode )
            show(menu_buf) ;

          out_getkey=FALSE ;
          do    /*--- Check the input key ---*/
          {
            key=pop_menu();

            if( !term_mode )
            {
              if( key==4 )      /* ctrl-D : shell */
              {
                show("\ntype 'EXIT' to go back to PowerBBS!\n");
                end_terminal() ;
                system(getenv("SHELL")) ;
                init_terminal() ;
                show("{#c#}");
                normal_text();
                show(menu_buf) ;
                continue ;
              }

              if( key==15 )     /* ctrl-O : set local directory path */
              {
                show("\n\n") ;
                show(DOWNPATH) ;
                getstring(-1,-1,LOCAL_DIR,60,1) ;
                show("{#c#}");
                normal_text();
                show(menu_buf) ;
                continue ;
              }
            }

	    if( key=='@' )	/* expert mode switch */
	    {
		expert_mode=!expert_mode;
		continue;
	    }

            out_getkey=map_key_menuprotocol(menu_protocol, key);

            if( out_getkey )
            {
              if( !strcmp(menu_protocol, "{Ping}") )
                  gettimeofday(&start_time,NULL) ;

              if( !strcmp(menu_protocol, "{Version_Info}") )
              {
                show(CLIENT_VER_NOTE1);
                show(CLIENT_VER_NOTE2);
                show(CLIENT_VER_NOTE3);
              }

              /*--- send menu protocol ---*/
              send_mpf(fd, menu_protocol, strlen(menu_protocol), MENU) ;

            }/*endif*/

          }
          while(!out_getkey) ;
          break ;
        /*-------------------------------------------------------*/
        case PASSWD:
          show(buffer) ;
          pwbuffer[0]=0 ;
          cnt=getstring(-1,-1,pwbuffer,10,2) ;
          show("\n") ;
          if(cnt<=0)
          {
            send_mpf(fd,pwbuffer,0,PASSWD) ;
            break ;
          }
          for(i=strlen(pwbuffer); i<10; i++)
            pwbuffer[i]=59+i*2 ;
          pwbuffer[10]=0 ;
          for(i=1; i<=10; i++)
          {
            pwbuffer[i-1]=(char) ((((pwbuffer[i-1]+pwbuffer[10-i])*67)%91)+32) ;
          }
          send_mpf(fd,pwbuffer,10,PASSWD) ;
          break ;
        /*-------------------------------------------------------*/
        case PECHO:
          gettimeofday(&end_time,NULL) ;
          mils=(end_time.tv_sec-start_time.tv_sec)*1000 ;
          mils+=end_time.tv_usec/1000 ;
          mils-=start_time.tv_usec/1000 ;
          sprintf(buffer,"\n     Ping echo from server in %7.2f seconds\n",(float) mils*0.001) ;
          show(buffer) ;
          break ;
        /*-------------------------------------------------------*/
        case POST:
          /*clear_esc(buffer) ;*/
          if((cnt=parse_header(buffer,header))==FALSE)
            break ;
          clear() ;
          refresh() ;
          strcat(buffer,"\n") ;
          strcat(buffer,POST_BOTTOM) ;
          i=pager(header,buffer) ;
          if(i>0)
          {
            sprintf(buffer,"%d",i) ;
            send_mpf(fd,buffer,strlen(buffer),GETPOST) ;
          }
          else
          {
            if(i==0)
            {
              send_mpf(fd,"q",1,GETPOST) ;
              show("\n\n") ;
            }
            if(i==-1)
            {
              send_mpf(fd,buffer,1,GETPOST) ;
            }

            if(i==-2)                   /*--- next post ---*/
            {
              sprintf(buffer,"%d",++cnt) ;
              send_mpf(fd,buffer,strlen(buffer),GETPOST) ;
            }
            if(i==-3)                   /*--- pre post ---*/
            {
              sprintf(buffer,"%d",--cnt) ;
              send_mpf(fd,buffer,strlen(buffer),GETPOST) ;
            }
          }
          break ;
        /*-------------------------------------------------------*/
        case PROMPT:
          parse_prompt(buffer) ;
          break ;
        /*-------------------------------------------------------*/
        case REJECT:
          quit=TRUE ;
          show(buffer) ;
          break ;
        /*-------------------------------------------------------*/
        case SCRSIZE:
          sprintf(buffer,"%d",SCR_ROWS-3) ;
          send_mpf(fd,buffer,strlen(buffer),SCRSIZE) ;
          break ;
        /*-------------------------------------------------------*/
        case SUSPEND:
          show(PRESSANYKEY) ;
          key=readkey() ;
	  if( key==27 )	/*maybe ANSI arrow*/
	  {
	    key=readkey();
	    if( key=='[' || key=='O' || key=='0' )
	      readkey();	/*make ANSI arrow look like a single key*/
	  }
          sprintf(buffer,"%c                                %c",13,13) ;
          show(buffer) ;
          break ;
        /*-------------------------------------------------------*/
        case TALK:
          chat_room(fd,buffer) ;
          break ;
        /*-------------------------------------------------------*/
        case YESNO:
          yesno_confirm(buffer);
          send_mpf(fd,buffer,1,YESNO) ;
          break;
        /*-------------------------------------------------------*/
        default:
          sprintf(buffer,"Error protocol : %d\n",prot) ;
          show(buffer) ;
          abnormal_disconnect(fd) ;
        /*-------------------------------------------------------*/
      }
    }
    else
    {
      if(tcpstat==-1)
      {
        hang_up("Error tcp communation!!\n",fd) ;
      }
    }
  }
  while(!quit) ;

  end_terminal() ;
}
/*end of main*/
/*************************************************************************/



/*
        broken-pipe --- when client and server run under the same host,
                        communication will be the pipe. If the pipe was
                        broken, this signal will be send.
                        So that, read() or write() cannot catch any error
                        if server process was terminated, only this signal
                        handler can catch this error!

                        coded by Samson Chen
*/
broken_pipe()
{
  if( success_then_remove )
  {
        printf("%s %s, %s\n\r", S_T_R_MSG, s_t_r_filename, PRESSANYKEY);
        readkey();
        success_then_remove=FALSE;      /*prevent from dup display*/
  }

  end_terminal();
}
/*end of broken_pipe*/
