/****************************************
  Phrase the prompt string from buffer.

  Write by Aqaurius Kuo.
  Apr 2, 1994.
*****************************************/
#include <string.h>
#include "pbbs.h"
#include "msg.h"

#define PATH            1
#define FROM            2
#define NEWSGROUP       3
#define SUBJECT         4
#define MID             5
#define DATE            6
#define ORGANIZATION    7
#define REPLY_TO        8

#define PAREA           11
#define PTOTAL          12
#define PNUM            13

#define PROMPT_INTERREAD        14

#define UNDEFINED       100

static char rcsid[]="$Id: parse.c,v 1.1 1995/11/11 08:47:27 pbbs Exp pbbs $" ;

extern int intrread_point;
char *kkytok() ;

/*
        parse_field --- parse message field (NNRP & PROMPT)
*/
parse_field(mh)
/*
  return: post number
*/
char *mh;
{

        if( !strncmp(mh, "CPInterread: ",13) )
                 return(PROMPT_INTERREAD) ;

        if( !strncmp(mh, "Area: ", 6) )
                 return(PAREA) ;

        if( !strncmp(mh, "Total: ", 7) )
                 return(PTOTAL) ;

        if( !strncmp(mh, "Msgno: ", 7) )
                 return(PNUM) ;

/*--- next if parse for RFC mail system standard ---*/

        if( !strncmp(mh, "Path: ", 6) )
                 return(PATH);

        if( !strncmp(mh, "From: ", 6) )
                return(FROM);

        if( !strncmp(mh, "Newsgroups: ", 12) )
                return(NEWSGROUP);

        if( !strncmp(mh, "Subject: ", 9) )
                return(SUBJECT);

        if( !strncmp(mh, "Message-ID: ", 12) )
                return(MID);

        if( !strncmp(mh, "Date: ", 6) )
                return(DATE);

        if( !strncmp(mh, "Organization: ", 14) )
                return(ORGANIZATION);

        if( !strncmp(mh, "Reply-To: ", 10) )
                return(REPLY_TO);

        return(UNDEFINED);
}
/*end of parse_field*/

int parse_prompt(buffer)
char *buffer ;
{
  char tmp[4] ;
  char *here, *ptr ;
  int ret, len ;

  ret=TRUE ;
  len=strlen(buffer) ;
  here=buffer ;
  sprintf(tmp,"%c%c",13,10) ;
  do
  {
    ptr=strstr(here,tmp) ;
    if(ptr==NULL)
    {
      ret=FALSE ;
      break ;
    }

    *ptr=0 ;
    switch(parse_field(here))
    {
      case PROMPT_INTERREAD:
        here+=13 ;
        strcpy(SELECTMSG,here) ;
        break ;
      default:
        ret=FALSE ;
    }
    here=ptr+2 ;
    if(here>=(buffer+len))
      break ;
  }
  while(ret==TRUE) ;

  return(0);
}
/* end parse_prompt */


int parse_header(buffer,header)
/*
   if phrase ok then
     return post number, buffer is body, header is mail-header
   else
     return FALSE, not define buffer and header.
*/
char *buffer ;
char *header ;
{
  char tmp[4],par[100] ;
  char *here, *ptr, *token ;
  char area[100], tota[100], msgn[100] ;
  char from[100], subj[100], date[100], orga[100], rept[100] ;
  int ret, len, pnum ;

  ret=TRUE ;
  len=strlen(buffer) ;
  area[0]=tota[0]=msgn[0]=from[0]=subj[0]=date[0]=orga[0]=rept[0]=0 ;
  here=buffer ;
  sprintf(tmp,"%c%c",13,10) ;
  do
  {
    ptr=strstr(here,tmp) ;
    if(ptr==NULL)
    {
      ret=FALSE ;
      break ;
    }

    *ptr=0 ;
    switch(parse_field(here))
    {
      case PAREA:
        here+=6 ;
        nstrcpy(area,here,100) ;
        while(strlen(area)<25)
          strcat(area," ") ;
        break ;
      case PTOTAL:
        here+=7 ;
        nstrcpy(tota,here,100) ;
        break ;
      case PNUM:
        here+=7 ;
        nstrcpy(msgn,here,100) ;
        pnum=atoi(msgn) ;
        break ;
      case PATH:
        here+=6 ;
        break ;

      case FROM:
        here+=6 ;
        nstrcpy(par,here,100) ;
        token=strtok(par,"()<>[]") ;
        if(token!=NULL)
        {
          token=strtok(NULL,"()<>[]") ;
          if(token!=NULL)
          {
            if( strlen(rept)==0 )
                strcpy(rept, par);

            strcpy(from,token) ;
            while(strlen(from)<25)
              strcat(from," ") ;
            break ;

            /*find ()<>[], strtok then BREAK*/
          }
        }

        nstrcpy(from,here,100) ;
        while(strlen(from)<25)
          strcat(from," ") ;
        break ;

      case NEWSGROUP:
        here+=12 ;
        break ;
      case SUBJECT:
        here+=9 ;
        nstrcpy(subj,here,80) ;
	/*set iread_mark*/
	if( !strncmp(subj, "Re: ", 4) )
	  nstrcpy(iread_mark, subj+4, 50);
	else
	  nstrcpy(iread_mark, subj, 50);
	/*pad subj*/
        while(strlen(subj)<80)
          strcat(subj," ") ;
        break ;
      case MID:
        here+=12 ;
        break ;
      case DATE:
        here+=6 ;
        nstrcpy(date,here,50) ;
        while(strlen(date)<50)
          strcat(date," ") ;
        break ;
      case ORGANIZATION:
        here+=14 ;
        nstrcpy(orga,here,80) ;
        len=strlen(POST_ORGAN) ;
        if(len+strlen(orga)>79)
          orga[79-len]=0 ;
        break ;
      case REPLY_TO:
        here+=10 ;
        nstrcpy(rept,here,100) ;
        break ;
      default:
        ret=FALSE ;
    }
    here=ptr+2 ;
    if((*here=='\r') || (*here=='n'))
    {
      here+=2 ;
      break ;
    }
  }
  while(ret==TRUE) ;

  /*--- Make mail header ---*/
  sprintf(header,"%.10s%-.25s%.10s%-.34s\n",SENDER,from,POST_REPLY,rept) ;
  sprintf(par,"%.10s%-.25s%.10s%-.34s\n",POST_AREA,area,POST_DATE,date) ;
  strcat(header,par) ;
  sprintf(par,"%.10s%-.65s\n",POST_SUBJECT,subj) ;
  strcat(header,par) ;
  sprintf(par,"%s%s\n",POST_ORGAN,orga) ;
  strcat(header,par) ;
  sprintf(par,"------------------------------------------------------------[%s/%s]---------------",msgn,tota) ;
  par[78]='\n' ;
  par[79]=0 ;
  strcat(header,par) ;
  strcpy(buffer,here) ;
  if(ret==FALSE)
    return(ret) ;
  else
  {
    if( intrread_point>0 )
        intrread_point=pnum;

    return(pnum) ;
  }
}
/* end parse_header */


/**************************************
   Parse the message about post data
*/
int parse_msg(pl,buf)
int *pl ;
char *buf ;
{
  char tmp1[100],tmp2[100],tmp0[100],crlf[3] ;
  char tmpbuf[6400] ;
  char *ptr ;
  int i, j ;

  if(strlen(buf)==0)
    return(0) ;

  sprintf(crlf,"%c%c",13,10) ;

  ptr=kkytok(buf,crlf) ;

  for(i=0; i<80; i++)
  {
    pl[i]=atoi(ptr) ;

    ptr=kkytok(NULL,crlf) ;
    strncpy(tmp0,ptr,55) ;
    tmp0[50]=0 ;
    for(j=0; j<50; j++)
    {
      if( tmp0[j]==9 || tmp0[j]==27 ) /* replace tab and esc to space */
        tmp0[j]=' ' ;
    }

    ptr=kkytok(NULL,crlf) ;
    strncpy(tmp1,ptr,22) ;
    tmp1[20]=0 ;

    sprintf(tmp2,"%4d %-20s %-50s",pl[i],tmp1,tmp0) ;
    strncpy(tmpbuf+i*100,tmp2,80) ;
    tmpbuf[i*100+80]=0 ;

    if((ptr=kkytok(NULL,crlf))==NULL)
    {
      memcpy(buf,tmpbuf,(i+1)*100) ;
      return(i+1) ;
    }
  }
  return(i) ;
}



/*
	nstrcpy --- some stange STRING hate strcpy... also size control is
		    needed
*/
nstrcpy(t, s, ms)
	char *t;	/*target*/
	char *s;	/*source*/
	int ms;		/*max size*/
{
	int cpn;

	for(cpn=0; cpn<ms; cpn++)
	{
		t[cpn]=s[cpn];

		if(s[cpn]==0)
			break;
	}

	t[ms-1]=0;
}
/*end of nstrcpy*/
