/*******************************************************************
    UPLOAD & DOWNLOAD file from server
    Write by Aquarius Kuo on Apr 9, 1994.

    Protocol re-defined and re-implemented by Samson Chen, Apr 1, 1995

    If you want to know detail about file-xfer protocol,
    please refer to the pbbs technical reference
*******************************************************************/
#include "pbbs.h"
#include "msg.h"

static char rcsid[]="$Id: file.c,v 1.2 1995/11/11 11:44:08 pbbs Exp pbbs $" ;

/***************************************
    download file from server to client
*/
int download(fd,buf,dmode)
int fd ;
char *buf ;
int dmode ;
{
  int handle,tcpstat ;
  int i ;
  char prot ;
  char fn[180], downdir[180] ;
  char tempdd[200];
  int tempcnt;
  char *map="-\\|/" ;
  char bs=8 ;
  long BLOCK=1024 ;
  long bsize[10],bn,bt ;
  long len1, flen, fcnt ;
  long get_size;
  int t_bar;    /*turning bar*/


  strcpy(fn,buf) ;
  if( fn[0]=='~' && fn[1]=='/' )
  {
    strcpy(downdir,getenv("HOME")) ;
    strcat(downdir,&fn[1]) ;
  }
  else
  {
    strcpy(downdir,fn) ;
  }

  handle=open(downdir,O_CREAT|O_EXCL|O_WRONLY,S_IREAD|S_IWRITE);
  if( handle<0 )
  {
    for(tempcnt=1; tempcnt<10; tempcnt++)
    {
      sprintf(tempdd, "%s.%d", downdir, tempcnt);
      handle=open(tempdd,O_CREAT|O_EXCL|O_WRONLY,S_IREAD|S_IWRITE);
      if( handle>0 ) break;
    }
  }

  if( handle<0 )
  {
    send_mpf(fd," ",1,STOPXFER) ;
    sprintf(buf,"\n%20s %s",fn,FILEEXIST) ;
    show(buf) ;
    return(FALSE) ;
  }

  /*open file good, send ACK*/
  send_mpf(fd," ", 1, XFER_ACK);

  /*get file length*/
  read_mpf(fd,buf,&len1,&prot,FALSE) ;
  buf[len1]=0 ;
  sscanf(buf,"%ld",&flen) ;

  /*draw the transfer meter*/
  if(dmode==2)
  {
    for(i=1; i<=10; i++)
    {
      bsize[i-1]=flen*i/(10*BLOCK) ;
    }
    if(flen<BLOCK)
    {
      bsize[9]=1 ;
    }
    else
    {
      bsize[9]=((flen%BLOCK)==0) ? bsize[9]-1:bsize[9] ;
    }

    printf("\n\r%20s  %10s  ",fn,ltostr(flen)) ;
    printf("..........%c%c%c%c%c%c%c%c%c%c",bs,bs,bs,bs,bs,bs,bs,bs,bs,bs) ;
    fflush(stdout) ;
  }

  /*assumes good(should check disk space before this), ready to receive*/
  send_mpf(fd," ",1,XFER_ACK) ;

  /*receive file until length flen*/
  bt=0;
  fcnt=0;
  t_bar=0;
  while(fcnt<flen)
  {
    get_size=flen-fcnt;
    if( get_size>BLOCK )
        get_size=BLOCK;

    if( (tcpstat=read(fd,buf,get_size)) >= 0 )
    {
      fcnt += tcpstat;
      write(handle, buf, tcpstat);
      bn=fcnt/BLOCK;
      t_bar++;

      if ( dmode==2 )
      {
        printf("%c%c",map[bn%4],bs) ;
        while((bn>bsize[bt]) && (bt<10))
        {
          printf("*") ;
          bt++ ;
        }
      fflush(stdout) ;
      }
    }
    else
    {
      abnormal_disconnect(fd);
      /*never return*/
    }

  }/*end while*/

  close(handle);

  if( dmode==2 )
  {
    while(bt<10)
    {
      printf("*") ;
      bt++ ;
    }
    fflush(stdout) ;
  }

  /*SYNCHRONIZATION*/
  tcpstat=read(fd, buf, 1);
  if( tcpstat<0 )
  {
      abnormal_disconnect(fd);
      /*never return*/
  }

  /*check SYNC*/
  if( buf[0]!=END_XFER )
  {
      hang_up("Synchronization error!\n");
      /*never return*/
  }

  /*sendback SYNC*/
  if( write(fd, buf, 1)<0 )
  {
      abnormal_disconnect(fd);
      /*never return*/
  }

  /*download finished*/

  return(TRUE) ;
}



/**************************************
    get the upload file name
*/
int get_filename(buffer)
char *buffer ;
{
  char pathfn[200] ;
  int i=0 ;

  while(i<1)
  {
    i++ ;
    pathfn[0]=0 ;
    show("\n") ;
    show(UFILENAME) ;
    if(getstring(-1,-1,pathfn,50,1)>0)
    {
      strcpy(buffer,pathfn) ;
      show("\n") ;
      return(TRUE) ;
    }
  }
  return(FALSE) ;
}

/**************************************
    upload a file from client to server
*/
int upload(fd,buffer,umode)
int fd ;
char *buffer ;
int umode ;
{
  int handle,tcpstat ;
  int i ;
  char prot ;
  char fn[80], *ptr ;
  char *map="-\\|/" ;
  char bs=8 ;
  long BLOCK=1024 ;
  long bsize[10],bn,bt ;
  long len1, flen ;
  long fcnt;
  int t_bar;
  char first_byte;

  strcpy(fn,buffer) ;
  for(i=0; i<strlen(fn); i++)   /*--- check file name ---*/
  {
    if(fn[i]<33)
    {
      fn[i]=0 ;
      break ;
    }
  }

  if((handle=open(fn,O_RDONLY))<0)      /* open upload file */
  {
    sprintf(buffer,"%s\n",FNOTFOUND) ;
    show(buffer) ;
    send_mpf(fd," ",1,STOPXFER) ;
    return(FALSE) ;
  }

  /*read first byte of the file to test it*/
  if( read(handle, &first_byte, 1) <= 0 )
  {
    sprintf(buffer,"%s\n",FILEREAD_ERR) ;
    show(buffer) ;
    send_mpf(fd, " ",1,STOPXFER) ;
    return(FALSE) ;
  }

  /*send filename*/
  send_mpf(fd, fn, strlen(fn), FILEXFER);

  /*check ACK*/
  read_mpf(fd,buffer,&len1,&prot,FALSE) ;
  if(prot==STOPXFER)
  {
    buffer[len1]=0 ;
    show(buffer) ;
    return(FALSE) ;
  }
  else if(prot!=XFER_ACK)
  {
    hang_up("Protocol State Error, %d!(U1)\n", prot);
    /*never return*/
  }

  /*send file length*/
  flen=flength(fn) ;
  sprintf(buffer,"%ld",flen) ;
  send_mpf(fd,buffer,strlen(buffer),FILEXFER) ;

  /*check ACK*/
  read_mpf(fd,buffer,&len1,&prot,FALSE) ;
  if(prot==STOPXFER)
  {
    buffer[len1]=0 ;
    show(buffer) ;
    return(FALSE) ;
  }
  else if(prot!=XFER_ACK)
  {
    hang_up("Protocol State Error, %d!(U2)\n", prot);
    /*never return*/
  }

  /*draw the transfer meter*/
  if(umode==2)
  {
    for(i=1; i<=10; i++)
    {
      bsize[i-1]=flen*i/(10*BLOCK) ;
    }
    if(flen<BLOCK)
    {
      bsize[9]=1 ;
    }
    else
    {
      bsize[9]=((flen%BLOCK)==0) ? bsize[9]-1:bsize[9] ;
    }

    printf("\n\r%20s  %10s  ",fn,ltostr(flen)) ;
    printf("..........%c%c%c%c%c%c%c%c%c%c",bs,bs,bs,bs,bs,bs,bs,bs,bs,bs) ;
    fflush(stdout) ;
  }

  /*send first byte of the file*/
  if( write(fd,&first_byte, 1) < 0 )
  {
        hang_up("Connection lost!(U1)\n") ;
        /*never return*/
  }

  /*send file until length flen*/
  bn=bt=0 ;
  fcnt=1;       /*include first byte*/
  t_bar=0;
  while(fcnt<flen)
  {
    len1=read(handle, buffer, BLOCK);

    if( len1==0 )       /*eof*/
    {
        hang_up("File size is not correct(underflow)!!!");
        /*stop transmission to save network*/
        break;
    }

    if( len1 < 0 )      /*read error*/
    {
        sprintf(buffer,"%s(U2R)\n",FILEREAD_ERR) ;
        hang_up(buffer) ;
        /*stop transmission to save network*/
        break;
    }

    if( len1 > (flen-fcnt) )
    {
        show("File size is not correct(overflow)!!!");
        len1=flen-fcnt;
        /*continue last transmission*/
    }

    if( write(fd, buffer, len1) < 0 )
    {
        hang_up("Connection lost!(U2)\n") ;
        /*never return*/
    }

    fcnt += len1;
    bn=fcnt/BLOCK;
    t_bar++;

    if ( umode==2 )
    {
      printf("%c%c",map[t_bar%4],bs) ;
      while((bn>bsize[bt]) && (bt<10))
      {
        printf("*") ;
        bt++ ;
      }
      fflush(stdout) ;
    }

  }/*end while*/

  if( umode==2 )
  {
    while(bt<10)
    {
      printf("*") ;
      bt++ ;
    }
    fflush(stdout) ;
  }

  /*send SYNC*/
  buffer[0]=END_XFER;
  if( write(fd, buffer, 1) < 0 )
  {
        hang_up("Connection lost!(U3)\n") ;
        /*never return*/
  }

  /*SYNCHRONIZATION*/
  if( read(fd, buffer, 1)<0 )
  {
        hang_up("Connection lost(U4)!\n");
        /*never return*/
  }

  /*check SYNC*/
  if( buffer[0]!=END_XFER )
  {
        hang_up("Synchronization error!\n");
        /*never return*/
  }

  /*upload finished*/

  return(TRUE) ;
}



file_exist(filename)
char *filename;
/*
        return: TRUE: exist
                FALSE: not exist
*/
{
        FILE *testexist;

        if( (testexist=fopen(filename, "r")) == NULL)
                return(FALSE);          /*not found*/
        else    /*file found*/
        {
                fclose(testexist);
                return(TRUE);
        }
}
/*end of file_exist*/



/*
        flength --- get length of a file
*/
flength(filename)
        char *filename;
{
        int test;
        unsigned long len;

        test=open(filename, O_RDONLY);
        lseek(test, 0, SEEK_END);
        len = tell(test);
        close(test);

        return(len);
}
/*end of flength*/

/*   #ifdef NETBSD   */
#ifdef TELL				/* Jones  */
/*
        NetBSD does not support tell() function, use fstat as alternative one
*/
tell(fd)
        int fd;
{
        struct stat buf;
        fstat(fd, &buf);
        return(buf.st_size);
}
#endif
