% code for stderrs via finite-difference

bandwidth=0.0000000000001;
q=0.5;
N=9; % number of judges in each court
R=round(q*N);
numcovar=7;
totjustice=31;
justicecovar=4;
oldnumpars=1+numcovar*3+(justicecovar+1)*2;
numpars=1+numcovar*3+(justicecovar+1)*2+3+4*2+ 2*2;

%% here load in the data, with variables term votesq
  s=  load('het9new3.raw');
ssize=size(s);
term=s(:,1);
voteall=s(:,2:1+totjustice);
termyear=s(:,ssize(2)-2);
issue_fed=s(:,ssize(2)-1);

casecovar=s(:, 1+totjustice+1: ssize(2)-2);

% extract the issue_rights cases;
issue_rights=casecovar(:,5);
issue_bus=casecovar(:,6);
issue_crim=casecovar(:,7);
rights_index=(issue_fed==1);
casecovar=casecovar(rights_index,[1:4 8:10]);

term=term(rights_index);
voteall=voteall(rights_index, :);
termyear=termyear(rights_index);

J=size(casecovar,1); %total number of cass in dataset (since we are pooling)
J

s2=load('justicesuse3.raw');
justicenum=s2(:,1);
juscovs=s2(:,2:1+justicecovar);
yearoath=s2(:,size(s2,2));

%dummies for chief justices
burger=(term>=1 & term<=7);
rehn=(term>=8 & term<=14);
roberts=(term>=15 & term<=16);

!rm -f vcov_fed.dry;
diary vcov_fed.dry; diary on;

load het6;  %% this contains converged paramorig from hetcase model

%% order of params:
%1: constant in p
%2 - numcovar+1: coefs of covars in p
%numcovar+2 - 2numcovar+1: coefs of covars in pi
%2numcovar+2 - 3numcovar+1: coefs of covars in pg
%3numcovar+2 - 3numcovar+1+justicecovar+1: cons&coefs of justicecovar in pi
%3numcovar+2+justicecovar+1 - 3numcovar+3+2justicecovar: cons&coefs of justicecovar in pg
%oldnumpars+1 - oldnumpars+3: coefs on burger, rehn, roberts in p
%oldnumpars+4 - oldnumpars+7: coefs on burger, rehn, roberts, yrsexp in pi
%oldnumpars+8 - oldnumpars+11: coefs on burger, rehn, roberts, yrsexp in pg
%oldnumpars+12 - oldnumpars+13: coefs on ideoint in pi
%oldnumpars+14 - oldnumpars+15: coefs on ideoint in pg

parampstart=1; 
parampend=numcovar+1; 
parampistart= parampend+1;
parampiend=parampend+numcovar;
parampgstart=parampiend+1; 
parampgend= parampiend+numcovar;
paramjuspistart=parampgend+1;
paramjuspiend=parampgend+justicecovar+1;
paramjuspgstart=paramjuspiend+1;
paramjuspgend=paramjuspiend+justicecovar+1;
paramjuspgstart=paramjuspiend+1;
paramjuspgend=paramjuspiend+justicecovar+1;

param1=paramorig;
vcov=zeros(numpars,numpars);
jacobian=zeros(J,numpars);
opg=zeros(numpars, numpars);


params=paramorig;
%% first map estimation parameter vectopr back to model parameters
paramp=params(parampstart:parampend);
parampg=params(parampgstart:parampgend);
parampi=params(parampistart:parampiend);
paramjuspi=params(paramjuspistart: paramjuspiend);
paramjuspg=params(paramjuspgstart: paramjuspgend);

paramnewp=params(oldnumpars+1: oldnumpars+3);
paramnewpi=params(oldnumpars+4: oldnumpars+7);
paramnewpg=params(oldnumpars+8: oldnumpars+11);
paramnewpi3=params(oldnumpars+12: oldnumpars+13);
paramnewpg3=params(oldnumpars+14: oldnumpars+15);

justicepg=zeros(totjustice,1); justicepi=zeros(totjustice,1);
for j=1:totjustice;
justicepi(j)=paramjuspi(1)+juscovs(j,:)*paramjuspi(2:justicecovar+1);
justicepg(j)=paramjuspg(1)+juscovs(j,:)*paramjuspg(2:justicecovar+1);
end;

% now calculate likelihood;
f=0.0;
llfxn=zeros(J,1);
for j=1:J; 

%% next select out the justices serving on that natural court
voteall1=voteall(j,:);
voteallindex=find(~isnan(voteall1));
ideoavg=sum(juscovs(voteallindex,3));
qualavg=sum(juscovs(voteallindex,4));

p=exp(paramp(1)+casecovar(j,:)*paramp(2:numcovar+1)+paramnewp(1)*burger(j)+paramnewp(2)*rehn(j)+paramnewp(3)*roberts(j))/(1+exp(paramp(1)+casecovar(j,:)*paramp(2:numcovar+1)+paramnewp(1)*burger(j)+paramnewp(2)*rehn(j)+paramnewp(3)*roberts(j)));

    piece1=1; piece2=1;
    for i=1:N;

i2=voteallindex(i);
yearexp=yearoath(i2)-termyear(j);
%ideoint=(N*juscovs(i2,3)-ideoavg)/(N-1);
%qualint=(N*juscovs(i2,4)-qualavg)/(N-1);
ideoint=(ideoavg-juscovs(i2,3))/(N-1);
qualint=(qualavg-juscovs(i2,4))/(N-1);

pi=exp(justicepi(i2)+casecovar(j,:)*parampi+paramnewpi(1)*burger(j)+paramnewpi(2)*rehn(j)+paramnewpi(3)*roberts(j)+paramnewpi(4)*yearexp+paramnewpi3(1)*ideoint+paramnewpi3(2)*qualint)/(1+exp(justicepi(i2)+casecovar(j,:)*parampi+paramnewpi(1)*burger(j)+paramnewpi(2)*rehn(j)+paramnewpi(3)*roberts(j)+paramnewpi(4)*yearexp+paramnewpi3(1)*ideoint+paramnewpi3(2)*qualint));

pg=(pi+exp(justicepg(i2)+casecovar(j,:)*parampg+paramnewpg(1)*burger(j)+paramnewpg(2)*rehn(j)+paramnewpg(3)*roberts(j)+paramnewpg(4)*yearexp+paramnewpg3(1)*ideoint+paramnewpg3(2)*qualint))/(1+exp(justicepg(i2)+casecovar(j,:)*parampg+paramnewpg(1)*burger(j)+paramnewpg(2)*rehn(j)+paramnewpg(3)*roberts(j)+paramnewpg(4)*yearexp+paramnewpg3(1)*ideoint+paramnewpg3(2)*qualint));

%[i p pi pg]

       piece1=piece1*(pg^(voteall(j,i2))*(1-pg)^(1-voteall(j,i2)));
       piece2=piece2*(pi^(voteall(j,i2))*(1-pi)^(1-voteall(j,i2)));
    end;


    llfxn(j)=log(p*piece1+(1-p)*piece2);
end;

% now perturb in each direction of parameters:
for i1=1:numpars;

i1

paramest=param1;
[i1 paramest(i1) bandwidth];
diffstep=bandwidth*paramest(i1);
paramest(i1)=paramest(i1)+diffstep;

paramp=paramest(parampstart:parampend);
parampg=paramest(parampgstart:parampgend);
parampi=paramest(parampistart:parampiend);
paramjuspi=paramest(paramjuspistart: paramjuspiend);
paramjuspg=paramest(paramjuspgstart: paramjuspgend);

paramnewp=paramest(oldnumpars+1: oldnumpars+3);
paramnewpi=paramest(oldnumpars+4: oldnumpars+7);
paramnewpg=paramest(oldnumpars+8: oldnumpars+11);
paramnewpi3=paramest(oldnumpars+12: oldnumpars+13);
paramnewpg3=paramest(oldnumpars+14: oldnumpars+15);

justicepg=zeros(totjustice,1); justicepi=zeros(totjustice,1);
for j=1:totjustice;
justicepi(j)=paramjuspi(1)+juscovs(j,:)*paramjuspi(2:justicecovar+1);
justicepg(j)=paramjuspg(1)+juscovs(j,:)*paramjuspg(2:justicecovar+1);
end;

% now calculate perturbed likelihood;
for j=1:J; 

%% next select out the justices serving on that natural court
voteall1=voteall(j,:);
voteallindex=find(~isnan(voteall1));
ideoavg=sum(juscovs(voteallindex,3));
qualavg=sum(juscovs(voteallindex,4));

p=exp(paramp(1)+casecovar(j,:)*paramp(2:numcovar+1)+paramnewp(1)*burger(j)+paramnewp(2)*rehn(j)+paramnewp(3)*roberts(j))/(1+exp(paramp(1)+casecovar(j,:)*paramp(2:numcovar+1)+paramnewp(1)*burger(j)+paramnewp(2)*rehn(j)+paramnewp(3)*roberts(j)));

    piece1=1; piece2=1;
    for i=1:N;

i2=voteallindex(i);
yearexp=yearoath(i2)-termyear(j);
%ideoint=(N*juscovs(i2,3)-ideoavg)/(N-1);
%qualint=(N*juscovs(i2,4)-qualavg)/(N-1);
ideoint=(ideoavg-juscovs(i2,3))/(N-1);
qualint=(qualavg-juscovs(i2,4))/(N-1);

pi=exp(justicepi(i2)+casecovar(j,:)*parampi+paramnewpi(1)*burger(j)+paramnewpi(2)*rehn(j)+paramnewpi(3)*roberts(j)+paramnewpi(4)*yearexp+paramnewpi3(1)*ideoint+paramnewpi3(2)*qualint)/(1+exp(justicepi(i2)+casecovar(j,:)*parampi+paramnewpi(1)*burger(j)+paramnewpi(2)*rehn(j)+paramnewpi(3)*roberts(j)+paramnewpi(4)*yearexp+paramnewpi3(1)*ideoint+paramnewpi3(2)*qualint));

pg=(pi+exp(justicepg(i2)+casecovar(j,:)*parampg+paramnewpg(1)*burger(j)+paramnewpg(2)*rehn(j)+paramnewpg(3)*roberts(j)+paramnewpg(4)*yearexp+paramnewpg3(1)*ideoint+paramnewpg3(2)*qualint))/(1+exp(justicepg(i2)+casecovar(j,:)*parampg+paramnewpg(1)*burger(j)+paramnewpg(2)*rehn(j)+paramnewpg(3)*roberts(j)+paramnewpg(4)*yearexp+paramnewpg3(1)*ideoint+paramnewpg3(2)*qualint));

%[i p pi pg]

       piece1=piece1*(pg^(voteall(j,i2))*(1-pg)^(1-voteall(j,i2)));
       piece2=piece2*(pi^(voteall(j,i2))*(1-pi)^(1-voteall(j,i2)));
    end;
jacobian(j,i1)=(log(p*piece1+(1-p)*piece2)-llfxn(j))/diffstep;
end;
end;

for j=1:J;
for i1=1:numpars; for i2=1:numpars;
if ~isnan(jacobian(j,i1))& ~isnan(jacobian(j,i2))
%opg(i1,i2)=opg(i1,i2)+(1/J)*(jacobian(j,i1)-mean(jacobian(:,i1)))*(jacobian(j,i2)-mean(jacobian(:,i2)));
opg(i1,i2)=opg(i1,i2)+(1/J)*(jacobian(j,i1))*(jacobian(j,i2));
end;
end;end;

end;

mean(opg')

vcov=inv(opg)/J;
save vcov_fed.txt vcov -ASCII;

disp('standard errors for paramest');
[param1 sqrt(diag(vcov)) param1./sqrt(diag(vcov))]
diary off;
