%% main for heterogeneous justices-9 vote model, allowing for covariates.
% add in four extra covariates: experience of justice, and dummies for chief justice 
% estimate only when issue_rights=1
    
clear all;
warning off;
global term votesq numpars q N termuse voteall J p pi pg casecovar totjustice parampstart parampend parampgstart parampgend parampistart parampiend estindex numest paramall estvect numcovar justicecovar juscovs paramjuspistart paramjuspiend paramjuspgstart paramjuspgend oldnumpars termyear yearoath burger rehn roberts;
format long g; 
format compact;

% parameters: p, pg, pi

q=0.5;
N=9; % number of judges in each court
R=round(q*N);
numcovar=7;
totjustice=31;
justicecovar=4;
oldnumpars=1+numcovar*3+(justicecovar+1)*2;
numpars=1+numcovar*3+(justicecovar+1)*2+3+4*2+ 2*2;

%% here load in the data, with variables term votesq
  s=  load('het9new3.raw');
ssize=size(s);
term=s(:,1);
voteall=s(:,2:1+totjustice);
termyear=s(:,ssize(2)-2);
issue_fed=s(:,ssize(2)-1);

casecovar=s(:, 1+totjustice+1: ssize(2)-2);

% extract the issue_rights cases;
issue_rights=casecovar(:,5);
issue_bus=casecovar(:,6);
issue_crim=casecovar(:,7);

%% next line selects the cases we estimate for (either issue_rights, issue_bus, issue_crim, or issue_fed)
rights_index=(issue_fed==1);

casecovar=casecovar(rights_index,[1:4 8:10]);

term=term(rights_index);
voteall=voteall(rights_index, :);
termyear=termyear(rights_index);

J=size(casecovar,1); %total number of cass in dataset (since we are pooling)
J

s2=load('justicesuse3.raw');
justicenum=s2(:,1);
juscovs=s2(:,2:1+justicecovar);
yearoath=s2(:,size(s2,2));

%dummies for chief justices
burger=(term>=1 & term<=7);
rehn=(term>=8 & term<=14);
roberts=(term>=15 & term<=16);

!rm -f hetcasemain_fed.dry;
diary hetcasemain_fed.dry; diary on;


paramorig=zeros(numpars,1);
%load het6;  %% this contains previous paramorig, in case you start with other starting values;

%% order of params:
%1: constant in p
%2 - numcovar+1: coefs of covars in p
%numcovar+2 - 2numcovar+1: coefs of covars in pi
%2numcovar+2 - 3numcovar+1: coefs of covars in pg
%3numcovar+2 - 3numcovar+1+justicecovar+1: cons&coefs of justicecovar in pi
%3numcovar+2+justicecovar+1 - 3numcovar+3+2justicecovar: cons&coefs of justicecovar in pg
%oldnumpars+1 - oldnumpars+3: coefs on burger, rehn, roberts in p
%oldnumpars+4 - oldnumpars+7: coefs on burger, rehn, roberts, yrsexp in pi
%oldnumpars+8 - oldnumpars+11: coefs on burger, rehn, roberts, yrsexp in pg
%oldnumpars+12 - oldnumpars+13: coefs on ideoint in pi
%oldnumpars+14 - oldnumpars+15: coefs on ideoint in pg

parampstart=1; 
parampend=numcovar+1; 
parampistart= parampend+1;
parampiend=parampend+numcovar;
parampgstart=parampiend+1; 
parampgend= parampiend+numcovar;
paramjuspistart=parampgend+1;
paramjuspiend=parampgend+justicecovar+1;
paramjuspgstart=paramjuspiend+1;
paramjuspgend=paramjuspiend+justicecovar+1;


estvect=zeros(size(paramorig));
estvect(1)=1; 
estvect(2:parampend)=1;
estvect(parampistart:parampiend)=1;
estvect(parampgstart:parampgend)=1;
estvect(3*numcovar+2: 3*numcovar+1+justicecovar+1)=1;
estvect(3*numcovar+justicecovar+3: 3*numcovar+2*justicecovar+3)=1;
estvect(oldnumpars+1: oldnumpars+3+2*4)=1;
%estvect(oldnumpars+1: oldnumpars+3)=0; %set to zero only if p=0.5
estvect(oldnumpars+12: oldnumpars+15)=1;
estvect(oldnumpars+16: oldnumpars+17)=1;


numest=sum(estvect)

estindex=find(estvect);
paramest=paramorig(estindex);
paramall=paramorig;

paramstart=paramest;

options=optimset('MaxFunEvals',1000000,'MaxIter',100000,'TolFun',0.001,'Algorithm','active-set', 'Simplex','on');

exitflag=0;
while exitflag~=1;
[paramest,funval,exitflag]=fminsearch('hetcase',paramstart,options);

paramstart=paramest;
%continput=input('Press 1 to continue estimating');
end;  % end while continput

format long g;
paramest

for i=1:numest
paramorig(estindex(i))=paramest(i);
end;

save het6 paramorig funval;  % save converged values

diary off;
